% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_git_status_code.R
\name{tar_git_status_code}
\alias{tar_git_status_code}
\title{Status of the code repository (Git)}
\usage{
tar_git_status_code(code = getwd())
}
\arguments{
\item{code}{Character of length 1, directory path to the code repository,
usually the root of the \code{targets} project.}
}
\value{
If the code repository exists, the return value is the data frame
produced by \code{gert::git_status(repo = code)}. If the code has no Git
repository, then the return value is \code{NULL}.
}
\description{
Show the Git status of the code repository.
}
\examples{
if (Sys.getenv("TAR_EXAMPLES") == "true" && tar_git_ok(verbose = FALSE)) {
targets::tar_dir({ # Containing code does not modify the user's file space.
targets::tar_script(tar_target(data, 1))
targets::tar_make()
list.files("_targets", all.files = TRUE)
gert::git_init()
tar_git_init()
tar_git_status_code()
})
}
}
\seealso{
Other git: 
\code{\link{tar_git_checkout}()},
\code{\link{tar_git_init}()},
\code{\link{tar_git_log}()},
\code{\link{tar_git_ok}()},
\code{\link{tar_git_snapshot}()},
\code{\link{tar_git_status_data}()},
\code{\link{tar_git_status_targets}()},
\code{\link{tar_git_status}()}
}
\concept{git}
