% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{git}
\alias{git}
\alias{is_git}
\alias{git_version}
\alias{git_checkout}
\title{Git Utilities}
\usage{
git(..., echo_cmd = TRUE)

is_git()

git_version()

git_checkout(branch = NULL)
}
\arguments{
\item{...}{Additional arguments passed to the system
command-line \verb{git <command> [<args>]} call.}

\item{echo_cmd}{Logical. Whether to print the command to run to the console.}

\item{branch}{Character. The name of a branch, typically a
feature branch.}
}
\value{
\code{\link[=git]{git()}}: The system call ... invisibly.

\code{is_git()}: Logical.

\code{git_version()}: Character. The system version of \code{git}.

\code{git_checkout()}: \code{NULL} ... invisibly.
}
\description{
Provides functionality for system-level git commands from within R.
}
\section{Functions}{
\itemize{
\item \code{git()}: executes a \code{git} command line call from within R.

\item \code{is_git()}: is current working directory a \code{git} repository?

\item \code{git_version()}: gets the version of git in use.

\item \code{git_checkout()}: \verb{git checkout} as a branch if doesn't exist. Branch
oriented workflow for switching between branches.

}}
\examples{
\dontrun{
git("status", "-s")

get_commit_msgs()

get_commit_msgs(n = 3)

get_pr_msgs()

# lint most recent 3 commit message
lapply(get_commit_msgs(n = 3), lint_commit_msg)

# for a PR `branch` -> `remotes/origin/{main,master}`
lapply(get_pr_msgs(), lint_commit_msg)           # current branch
lapply(get_pr_msgs("feature"), lint_commit_msg)  # `feature` branch

get_recent_tag()
}
}
