% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects_and_repos.R
\name{gl_get_project_id}
\alias{gl_get_project_id}
\title{Get a project id by name}
\usage{
gl_get_project_id(project_name, ...)
}
\arguments{
\item{project_name}{project name}

\item{...}{passed on to \code{\link[=gitlab]{gitlab()}}}
}
\value{
Integer. ID of the project if found.
}
\description{
Get a project id by name
}
\details{
Number of pages searched is limited to (per_page =) 20 * (max_page =) 10 by default.
If the \code{project_name} is an old project lost in a big repository (position > 200),
\code{gl_get_project_id()} may not find the project id.
}
\examples{
\dontrun{
gl_get_project_id("<<your-project-name>>")
}
}
