% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{use_gitlab_ci}
\alias{use_gitlab_ci}
\title{Add .gitlab-ci.yml file in your current project from template}
\usage{
use_gitlab_ci(
  image = "rocker/verse:latest",
  repo_name = "https://packagemanager.rstudio.com/all/__linux__/focal/latest",
  url = "https://gitlab.com",
  path = ".gitlab-ci.yml",
  overwrite = TRUE,
  add_to_Rbuildignore = TRUE,
  type = "check-coverage-pkgdown"
)
}
\arguments{
\item{image}{Docker image to use in GitLab ci. If NULL, not specified!}

\item{repo_name}{REPO_NAME environment variable for R CRAN mirror used}

\item{url}{url of the GitLab instance}

\item{path}{destination path for writing GitLab CI yml file}

\item{overwrite}{whether to overwrite existing GitLab CI yml file}

\item{add_to_Rbuildignore}{add CI yml file (from \code{path}) to .Rbuildignore?}

\item{type}{type of the CI template to use}
}
\value{
Used for side effects. Creates a .gitlab-ci.yml file in your directory.
}
\description{
Add .gitlab-ci.yml file in your current project from template
}
\details{
Types available are:
\itemize{
\item "check-coverage-pkgdown": Check package along with Code coverage with {covr}
and {pkgdown} site on GitLab Pages
\item "check-coverage-pkgdown-renv": Check package built in a fixed {renv} state
along with Code coverage with {covr} and {pkgdown} site on GitLab Pages.
\item "bookdown": Build {bookdown} HTML and PDF site on GitLab Pages
\item "bookdown-production": Build {bookdown} HTML and PDF site on GitLab Pages.
Where default page is for branch named 'production' and "dev/" sub-folder is for
'main' (or 'master') branch.
}
}
\examples{
# Create in another directory
use_gitlab_ci(image = "rocker/verse:latest", path = tempfile(fileext = ".yml"))
\dontrun{
# Create in your current project with template for packages checking
use_gitlab_ci(image = "rocker/verse:latest", type = "check-coverage-pkgdown")
}
}
