% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{is_bare}
\alias{is_bare}
\title{Check if repository is bare}
\usage{
is_bare(repo = ".")
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}
}
\value{
\code{TRUE} if bare repository, else \code{FALSE}
}
\description{
Check if repository is bare
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
is_bare(repo)

## Initialize a bare repository
path_bare <- tempfile(pattern="git2r-")
dir.create(path_bare)
repo_bare <- init(path_bare, bare = TRUE)
is_bare(repo_bare)
}
}
\seealso{
\link{init}
}
