% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{is_tag}
\alias{is_tag}
\title{Check if object is a git_tag object}
\usage{
is_tag(object)
}
\arguments{
\item{object}{Check if object is a git_tag object}
}
\value{
TRUE if object is a git_tag, else FALSE
}
\description{
Check if object is a git_tag object
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

is_tag(tags(repo)[[1]])
is_tag(last_commit(repo))
}
}
