% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-id-api.R
\name{gisco_id_api}
\alias{gisco_id_api}
\alias{gisco_id_api_geonames}
\alias{gisco_id_api_nuts}
\alias{gisco_id_api_lau}
\alias{gisco_id_api_country}
\alias{gisco_id_api_river_basin}
\alias{gisco_id_api_biogeo_region}
\alias{gisco_id_api_census_grid}
\title{GISCO ID service API}
\source{
\url{https://gisco-services.ec.europa.eu/id/api-docs/}.
}
\usage{
gisco_id_api_geonames(
  x = NULL,
  y = NULL,
  xmin = NULL,
  ymin = NULL,
  xmax = NULL,
  ymax = NULL,
  verbose = FALSE
)

gisco_id_api_nuts(
  x = NULL,
  y = NULL,
  year = 2024,
  epsg = c(4326, 4258, 3035),
  verbose = FALSE,
  nuts_id = NULL,
  nuts_level = NULL,
  geometry = TRUE
)

gisco_id_api_lau(
  x,
  y,
  year = 2024,
  epsg = c(4326, 4258, 3035),
  verbose = FALSE,
  geometry = TRUE
)

gisco_id_api_country(
  x,
  y,
  year = 2024,
  epsg = c(4326, 4258, 3035),
  verbose = FALSE,
  geometry = TRUE
)

gisco_id_api_river_basin(
  x,
  y,
  year = 2019,
  epsg = c(4326, 4258, 3035),
  verbose = FALSE,
  geometry = TRUE
)

gisco_id_api_biogeo_region(
  x,
  y,
  year = 2016,
  epsg = c(4326, 4258, 3035),
  verbose = FALSE,
  geometry = TRUE
)

gisco_id_api_census_grid(
  x,
  y,
  year = 2021,
  epsg = c(4326, 4258, 3035),
  verbose = FALSE,
  geometry = TRUE
)
}
\arguments{
\item{x, y}{character string or numeric. x and y coordinates (as longitude
and latitude) to be identified.}

\item{xmin, ymin, xmax, ymax}{character string or numeric. Bounding box
coordinates to identify all geonames within the box.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{year}{character string or numeric. Year of the dataset, see
\strong{Details}.}

\item{epsg}{character string or numeric. EPSG code for the coordinate
reference system.}

\item{nuts_id}{character. NUTS ID code.}

\item{nuts_level}{character string. NUTS level. One of \code{0},
\code{1}, \code{2} or \code{3}.}

\item{geometry}{logical. Whether to return geometry. On \code{TRUE} a
\code{\link[sf:sf]{sf}} object would be returned. On \code{FALSE} a
\link[tibble:tbl_df-class]{tibble} would be returned.}
}
\value{
A \link[tibble:tbl_df-class]{tibble} or a \code{\link[sf:sf]{sf}} object.
}
\description{
Functions to interact with the \href{https://gisco-services.ec.europa.eu/id/api-docs/}{GISCO ID service API}, which returns
attributes and, optionally, geometry for different datasets at specified
longitude and latitude coordinates.

Each endpoint available is implemented through a specific function, see
\strong{Details}.
}
\details{
The available endpoints are:
\itemize{
\item \code{gisco_id_api_geonames()}: Get geographic placenames either from x/y
coordinates or a bounding box.
\item \code{gisco_id_api_nuts()}: Returns NUTS regions from either a specified
longitude and latitude (x,y) or id. Accepted \code{year}
\Sexpr[stage=render,results=rd]{giscoR:::docs_id_years("nuts")}.
\item \code{gisco_id_api_lau()}: Returns the id and - optionally - geometry for Large
Urban Areas (LAU) at specified longitude and latitude (x,y). Accepted
\code{year}
\Sexpr[stage=render,results=rd]{giscoR:::docs_id_years("lau")}.
\item \code{gisco_id_api_country()}: Returns the id and - optionally - geometry for
countries at specified longitude and latitude (x,y). Accepted \code{year}
\Sexpr[stage=render,results=rd]{giscoR:::docs_id_years("country")}.
\item \code{gisco_id_api_river_basin()}: Returns the id and - optionally - geometry
for river basins at specified longitude and latitude (x,y), based on the
Water Framework Directive (WFD) reference spatial data sets. Accepted
\code{year}
\Sexpr[stage=render,results=rd]{giscoR:::docs_id_years("riverbasin")}.
\item \code{gisco_id_api_biogeo_region()}: Returns the id and - optionally - geometry
for biogeo regions at specified longitude and latitude (x,y). The
biogeographical regions dataset contains the official delineations used in
the Habitats Directive (92/43/EEC) and for the EMERALD Network. Accepted
\code{year}
\Sexpr[stage=render,results=rd]{giscoR:::docs_id_years("biogeoregion")}.
\item \code{gisco_id_api_census_grid()}: Returns the id and - optionally - geometry
for census grid cells at specified longitude and latitude (x,y). Accepted
\code{year}
\Sexpr[stage=render,results=rd]{giscoR:::docs_id_years("censusgrid")}.
}
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
gisco_id_api_geonames(x = -2.5, y = 43.06)

lau <- gisco_id_api_lau(x = -2.5, y = 43.06)
nuts3 <- gisco_id_api_nuts(x = -2.5, y = 43.06, nuts_level = 3)

if (all(!is.null(lau), !is.null(nuts3))) {
  library(ggplot2)

  ggplot(nuts3) +
    geom_sf(fill = "lightblue", color = "black") +
    geom_sf(data = lau, fill = "orange", color = "red") +
    labs(
      title = "NUTS3 and LAU boundaries",
      subtitle = "Arrasate, Basque Country, Spain",
      caption = "Source: GISCO ID service API"
    )
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gisco_get_nuts]{gisco_get_nuts()}}, \code{\link[=gisco_get_lau]{gisco_get_lau()}}, \code{\link[=gisco_get_countries]{gisco_get_countries()}},
\code{\link[=gisco_get_census]{gisco_get_census()}}.

Other API tools: 
\code{\link{gisco_address_api}}
}
\concept{API tools}
