% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_data.R
\docType{data}
\encoding{UTF-8}
\name{gisco_countries}
\alias{gisco_countries}
\title{World countries \code{POLYGON} object}
\format{
A \code{MULTIPOLYGON} data frame
(resolution: 1:20million, EPSG:4326) object with 257 rows and 7 variables:
\describe{
  \item{id}{row ID}
  \item{CNTR_NAME}{Official country name on local language}
  \item{ISO3_CODE}{\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{ISO 3166-1 alpha-3 code} of
  each country, as provided by GISCO}
  \item{CNTR_ID}{Country ID}
  \item{NAME_ENGL}{Country name in English}
  \item{FID}{FID}
  \item{geometry}{geometry field}
}
}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/countries/geojson/CNTR_RG_20M_2016_4326.geojson}{GISCO .geojson source}
}
\description{
A \code{sf} object including all
countries as provided by GISCO (2016 version).
}
\examples{
library(sf)

cntry <- gisco_countries
GBR <- subset(cntry, ISO3_CODE == "GBR")

plot(st_geometry(GBR), col = "red3", border = "blue4")
title(sub = gisco_attributions(), line = 1)

}
\seealso{
\link{gisco_get_countries}
}
