% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gips_perm_class.R
\name{gips_perm}
\alias{gips_perm}
\alias{new_gips_perm}
\alias{validate_gips_perm}
\title{Permutation object}
\usage{
gips_perm(x, size)

new_gips_perm(rearranged_cycles, size)

validate_gips_perm(g)
}
\arguments{
\item{x}{A single object that can be interpreted by
the \code{\link[permutations:permutation]{permutations::permutation()}} function.
For example, the character of a form \code{"(1,2)(4,5)"}. See examples.
It can also be of a \code{gips} class but
it will be interpreted as the underlying \code{gips_perm}.}

\item{size}{An integer. Size of a permutation
(AKA cardinality of a set, on which permutation is defined. See examples).}

\item{rearranged_cycles}{A list of rearranged integer vectors.
Each vector corresponds to a single cycle of a permutation.}

\item{g}{Object to be checked whether it is
a proper object of a \code{gips_perm} class.}
}
\value{
\code{gips_perm()} returns an object of
a \code{gips_perm} class after the safety checks.

\code{new_gips_perm()} returns an object of
a \code{gips_perm} class without the safety checks.

\code{validate_gips_perm()} returns its argument unchanged.
If the argument is not a proper element of a \code{gips_perm} class,
it produces an error.
}
\description{
Create permutation objects to be passed to
other functions of the \code{gips} package.
}
\section{Functions}{
\itemize{
\item \code{new_gips_perm()}: Constructor. Only intended for low-level use.

\item \code{validate_gips_perm()}: Validator. Only intended for low-level use.

}}
\section{Methods for a \code{gips} class}{

\itemize{
\item \code{\link[=as.character.gips_perm]{as.character.gips_perm()}}
\item \code{\link[=print.gips_perm]{print.gips_perm()}}
}
}

\examples{
# All 7 following lines give the same output:
gperm <- gips_perm("(12)(45)", 5)
gperm <- gips_perm("(1,2)(4,5)", 5)
gperm <- gips_perm(as.matrix(c(2, 1, 3, 5, 4)), 5)
gperm <- gips_perm(t(as.matrix(c(2, 1, 3, 5, 4))), 5) # both way for a matrix works
gperm <- gips_perm(list(list(c(2, 1), c(4, 5))), 5)
gperm <- gips_perm(permutations::as.word(c(2, 1, 3, 5, 4)), 5)
gperm <- gips_perm(permutations::as.cycle("(1,2)(4,5)"), 5)
gperm

# note the necessity of the `size` parameter:
gperm <- gips_perm("(12)(45)", 5)
gperm <- gips_perm("(12)(45)", 7) # this one is a different permutation

try(gperm <- gips_perm("(12)(45)", 4))
# Error, `size` was set to 4, while the permutation has the element 5.

}
\seealso{
\itemize{
\item \code{\link[=project_matrix]{project_matrix()}} - \code{gips_perm} is the \code{perm} parameter of \code{project_matrix()}.
\item \code{\link[permutations:permutation]{permutations::permutation()}} - The constructor for the \code{x} parameter.
\item \code{\link[=gips]{gips()}} - The constructor for the \code{gips} class uses
the \code{gips_perm} object as the base object.
}
}
