% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/monthlyIndices.R
\name{monthlyIndices}
\alias{monthlyIndices}
\title{Monthly indices from GIMMS filenames}
\usage{
monthlyIndices(x, pos1 = 4L, pos2 = 8L)
}
\arguments{
\item{x}{Character. Vector of (local or online) filenames.}

\item{pos1,pos2}{Numeric. The first and last element of the date string in
'x', defaults to the GIMMS naming convention; see \code{\link{substr}}.}
}
\value{
A numeric vector with unique monthly indices.
}
\description{
Create numeric monthly indices from (local or online) GIMMS filenames as
input for the \code{\link{monthlyComposite}} function.
}
\examples{
## vector of filenames
gimms_files <- c("geo85aug15a.n09-VI3g", "geo85aug15b.n09-VI3g",
                 "geo85sep15a.n09-VI3g", "geo85sep15b.n09-VI3g",
                 "geo85oct15a.n09-VI3g", "geo85oct15b.n09-VI3g")

## extract monthly indices
monthlyIndices(gimms_files)
}
\author{
Florian Detsch
}
\seealso{
\code{\link{monthlyComposite}}.
}

