% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.ggvis}
\alias{print.ggvis}
\alias{view_static}
\alias{view_dynamic}
\title{View in a ggvis plot in the browser.}
\usage{
\method{print}{ggvis}(x, dynamic = NA, launch = interactive(), ...)

view_static(x, plot_id = rand_id("plot_"), dest = NULL)

view_dynamic(x, plot_id = rand_id("plot_"), port = NULL, quiet = FALSE)
}
\arguments{
\item{x}{A ggvis object.}

\item{dynamic}{Uses \code{view_dynamic} if \code{TRUE}, \code{view_static} if
\code{FALSE}. The default, \code{NA}, chooses automatically based on the
presence of reactives or interactive inputs in \code{x}.}

\item{launch}{If \code{TRUE}, will launch plot in a viewer/browser. If
\code{FALSE} returns an object that you can \code{print()} to launch.}

\item{...}{Other arguments passed on to \code{view_dynamic} and
\code{view_static} ?from \code{print}.}

\item{plot_id}{Unique identifier used to identify the plot on the page.}

\item{dest}{Deprecated (this no longer works).}

\item{port}{the port on which to start the shiny app. If NULL (the default),
Shiny will select a random port.}

\item{quiet}{If \code{TRUE} show status messages from Shiny. (Default is
\code{FALSE}.)}
}
\description{
\code{view_static} creates a static web page in a temporary directory;
\code{view_dynamic} generate a dynamic shiny app and launches it.
\code{print} automatically picks between the two.
}
\details{
If \code{view_static} is used on a ggvis object that has dynamic components,
it will output a static plot.
}
\examples{
## Run these examples only in interactive R sessions
if (interactive()) {
# In most cases view_static is unnecessary; these will do the same thing:
mtcars \%>\% ggvis(~wt, ~mpg)
mtcars \%>\% ggvis(~wt, ~mpg) \%>\% view_static()

# Can find the output file with view_static() and html_print()
outfile <- mtcars \%>\% ggvis(~wt, ~mpg) \%>\%
  view_static() \%>\% htmltools::html_print(viewer = NULL)
}
}
\keyword{internal}
