% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_venn.R
\name{geom_venn}
\alias{geom_venn}
\title{Plot venn diagram as a ggplot layer object. It supports only data frame as input.}
\usage{
geom_venn(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  set_names = NULL,
  show_percentage = TRUE,
  digits = 1,
  label_sep = ",",
  count_column = NULL,
  show_outside = c("auto", "none", "always"),
  auto_scale = FALSE,
  fill_color = c("blue", "yellow", "green", "red"),
  fill_alpha = 0.5,
  stroke_color = "black",
  stroke_alpha = 1,
  stroke_size = 1,
  stroke_linetype = "solid",
  set_name_color = "black",
  set_name_size = 6,
  text_color = "black",
  text_size = 4
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{A data.frame or a list as input data.}

\item{stat}{The statistical transformation to use on the data for this layer, as a string.}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{set_names}{Set names, use column names if omitted.}

\item{show_percentage}{Show percentage for each set.}

\item{digits}{The desired number of digits after the decimal point}

\item{label_sep}{separator character for displaying elements.}

\item{count_column}{Specify column for element repeat count.}

\item{show_outside}{Show outside elements (not belongs to any set).}

\item{auto_scale}{Allow automatically resizing circles according to element counts.}

\item{fill_color}{Filling colors in circles.}

\item{fill_alpha}{Transparency for filling circles.}

\item{stroke_color}{Stroke color for drawing circles.}

\item{stroke_alpha}{Transparency for drawing circles.}

\item{stroke_size}{Stroke size for drawing circles.}

\item{stroke_linetype}{Line type for drawing circles.}

\item{set_name_color}{Text color for set names.}

\item{set_name_size}{Text size for set names.}

\item{text_color}{Text color for intersect contents.}

\item{text_size}{Text size for intersect contents.}
}
\value{
The ggplot object to print or save to file.
}
\description{
Plot venn diagram as a ggplot layer object. It supports only data frame as input.
}
\examples{
library(ggvenn)

# use data.frame as input
d <- tibble(value   = c(1,     2,     3,     5,     6,     7,     8,     9),
            `Set 1` = c(TRUE,  FALSE, TRUE,  TRUE,  FALSE, TRUE,  FALSE, TRUE),
            `Set 2` = c(TRUE,  FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, TRUE),
            `Set 3` = c(TRUE,  TRUE,  FALSE, FALSE, FALSE, FALSE, TRUE,  TRUE),
            `Set 4` = c(FALSE, FALSE, FALSE, FALSE, TRUE,  TRUE,  FALSE, FALSE))

# ggplot gramma
ggplot(d) +
  geom_venn(aes(A = `Set 1`, B = `Set 2`)) +
  coord_fixed() +
  theme_void()
ggplot(d) +
  geom_venn(aes(A = `Set 1`, B = `Set 2`, C = `Set 3`)) +
  coord_fixed() +
theme_void()
ggplot(d) +
  geom_venn(aes(A = `Set 1`, B = `Set 2`, C = `Set 3`, D = `Set 4`)) +
  coord_fixed() +
  theme_void()

# set fill color
ggplot(d) +
  geom_venn(aes(A = `Set 1`, B = `Set 2`), fill_color = c("red", "blue")) +
  coord_fixed() +
  theme_void()

# hide percentage
ggplot(d) +
  geom_venn(aes(A = `Set 1`, B = `Set 2`), show_percentage = FALSE) +
  coord_fixed() +
  theme_void()

# change precision of percentages
ggplot(d) +
  geom_venn(aes(A = `Set 1`, B = `Set 2`), digits = 2) +
  coord_fixed() +
  theme_void()

# show elements instead of count/percentage
ggplot(d) +
  geom_venn(aes(A = `Set 1`, B = `Set 2`, C = `Set 3`, D = `Set 4`, label = value)) +
  coord_fixed() +
  theme_void()
}
\seealso{
ggvenn
}
