% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fivenumber.R
\docType{data}
\name{stat_fivenumber}
\alias{StatFivenumber}
\alias{stat_fivenumber}
\title{Calculate components of a five-number summary}
\usage{
stat_fivenumber(mapping = NULL, data = NULL, geom = "boxplot", qs = c(0,
  0.25, 0.5, 0.75, 1), na.rm = FALSE, position = "identity",
  show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{qs}{Quantiles to use for the five number summary.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\value{
A data frame with additional columns:
  \item{width}{width of boxplot}
  \item{min}{minimum}
  \item{lower}{lower hinge, 25\% quantile}
  \item{middle}{median, 50\% quantile}
  \item{upper}{upper hinge, 75\% quantile}
  \item{max}{maximum}
}
\description{
The five number summary of a sample is the minimum, first quartile,
median, third quartile, and maximum.
}
\seealso{
\code{\link{stat_boxplot}}
}
\keyword{datasets}

