% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{plot_theme}
\alias{plot_theme}
\alias{add_theme}
\alias{\%+replace\%}
\alias{update_theme}
\alias{calc_element}
\alias{zzz-overloaded}
\alias{validate_element}
\alias{theme_update}
\title{\code{plot_theme} is a local copy of the method that determines the net theme between a plot and the current global theme.}
\format{functions and objects}
\usage{
plot_theme(x)

add_theme(t1, t2, t2name)

e1 \%+replace\% e2

update_theme(oldtheme, newtheme)

calc_element(element, theme, verbose = FALSE)

validate_element(el, elname)

theme_update(...)
}
\arguments{
\item{x}{gg object}

\item{t1}{A theme object}

\item{t2}{A theme object that is to be added to \code{t1}}

\item{t2name}{A name of the t2 object. This is used for printing
informative error messages.}

\item{e1}{Theme and element to combine}

\item{e2}{Theme and element to combine}

\item{oldtheme}{previous theme object}

\item{newtheme}{new theme object}

\item{element}{The name of the theme element to calculate}

\item{theme}{A theme object (like \code{\link[=theme_grey]{theme_grey()}})}

\item{verbose}{If TRUE, print out which elements this one inherits from}

\item{el}{the element}

\item{elname}{the element name}

\item{...}{named list of theme settings}
}
\description{
INTERNAL FUNCTIONS (Overloaded from ggplot2): The source of the following functions originate 
from ggplot2, however, minor patches were required in order for them to function under the ggtern framework. 
Patches were mainly to do with handling the new theme elements and heirarchies.

\code{validate_element} is a local copy of the ggplot2 function which checks the validity of a given theme element 
against the elements table. Since the \code{.elements_tree} is an internal function, which is not exported, and modifications could not be made, 
a new (and equivalent) \code{.element_tree} is created within ggtern to handle the new theme elements created within this package.
}
\seealso{
\code{\link[ggplot2]{add_theme}}

\code{\link[ggplot2]{theme_update}}
}
\author{
Nicholas Hamilton
}
\keyword{internal}
