% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quantile.R
\name{add_quantile}
\alias{add_quantile}
\title{Add Quantile Annotation}
\usage{
add_quantile(y_value = 0.5, ...)
}
\arguments{
\item{y_value}{Numeric value where the line segment will be drawn. Default is \code{0.5}}

\item{...}{Named arguments passed to \code{ggplot2::geom_segment()} with default \code{linetype = 2}}
}
\value{
a ggplot2 figure
}
\description{
Add quantile information annotated on to the plot.
}
\examples{
survfit2(Surv(time, status) ~ sex, data = df_lung) \%>\%
  ggsurvfit() +
  add_quantile(linetype = 2)

survfit2(Surv(time, status) ~ 1, data = df_lung) \%>\%
  ggsurvfit() +
  add_quantile(linetype = 2) +
  add_quantile(y_value = 0.9, linetype = 3)
}
