% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{grouped_list}
\alias{grouped_list}
\title{Split dataframe into a list by grouping variable.}
\usage{
grouped_list(data, grouping.var = NULL)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted.}

\item{grouping.var}{A single grouping variable.}
}
\description{
This function splits the dataframe into a list, with the length
of the list equal to the factor levels of the grouping variable. Each
element of the list will be a tibble.
}
\examples{
\donttest{
ggstatsplot:::grouped_list(ggplot2::msleep, grouping.var = vore)
}
}
\keyword{internal}
