% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{movies_long}
\alias{movies_long}
\title{Movie information and user ratings from IMDB.com (long format).}
\format{A data frame with 2433 rows and 8 variables
\itemize{
\item title.  Title of the movie.
\item year.  Year of release.
\item budget.  Total budget (if known) in US dollars
\item length.  Length in minutes.
\item rating.  Average IMDB user rating.
\item votes.  Number of IMDB users who rated this movie.
\item mpaa.  MPAA rating.
\item genre. Different genres of movies (action, animation, comedy, drama,
documentary, romance, short).
}}
\source{
\url{https://CRAN.R-project.org/package=ggplot2movies}
}
\usage{
movies_long
}
\description{
Movie information and user ratings from IMDB.com (long format).
}
\details{
Modified dataset from \code{ggplot2movies} package.

The internet movie database, \url{http://imdb.com/}, is a website devoted
to collecting movie data supplied by studios and fans.  It claims to be the
biggest movie database on the web and is run by amazon.  More about
information imdb.com can be found online,
\url{http://imdb.com/help/show_leaf?about}, including information about
the data collection process,
\url{http://imdb.com/help/show_leaf?infosource}.

Movies were selected for inclusion if they had a known length and had been
rated by at least one imdb user.
}
\examples{
dim(movies_long)
head(movies_long)
}
\keyword{datasets}
