% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_oneway_anova}
\alias{bf_oneway_anova}
\title{Bayesian one-way analysis of variance.}
\usage{
bf_oneway_anova(data, x, y, bf.prior = 0.707, caption = NULL,
  output = "caption", k = 2)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{caption}{The text for the plot caption.}

\item{output}{Can either be \code{"caption"} (which will contain text for evidence
in favor of null)  or \code{"results"} (which will return the dataframe with
results).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}
}
\description{
Bayesian one-way analysis of variance.
}
\examples{

# to get caption (default)
bf_oneway_anova(
  data = iris,
  x = Species,
  y = Sepal.Length,
  bf.prior = 0.8
)

# to get results dataframe
bf_oneway_anova(
  data = iris,
  x = Species,
  y = Sepal.Length,
  bf.prior = 0.8,
  output = "results"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_corr_test}},
\code{\link{bf_two_sample_ttest}}
}
\author{
Indrajeet Patil
}
