% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_caption_maker}
\alias{bf_caption_maker}
\title{Prepare caption with bayes factor in favor of null}
\usage{
bf_caption_maker(bf.df, k = 2, caption = NULL, ...)
}
\arguments{
\item{bf.df}{A dataframe containing two columns \code{log_e_bf01} and \code{bf.prior}.
If dataframe contains more than two rows, only the first row will be used.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{caption}{Text to display as caption (will be displayed on top of the
bayes factor caption/message).}

\item{...}{Additional arguments (ignored).}
}
\description{
Convenience function to write a caption message with bayes
factors in favor of the null hypothesis.
}
\examples{

set.seed(123)

# dataframe containing results
bf_results <-
  bf_extractor(BayesFactor::correlationBF(
    x = iris$Sepal.Length,
    y = iris$Petal.Length
  )) \%>\%
  dplyr::mutate(.data = ., bf.prior = 0.707)

# creating caption
ggstatsplot::bf_caption_maker(
  bf.df = bf_results,
  k = 3,
  caption = "Note: Iris dataset"
)
}
