% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-spatial-bbox.R
\name{layer_spatial.bbox}
\alias{layer_spatial.bbox}
\alias{annotation_spatial.bbox}
\alias{shadow_spatial.bbox}
\title{Add a bounding box to a map}
\usage{
\method{layer_spatial}{bbox}(data, mapping = aes(), ..., detail = 30)

\method{annotation_spatial}{bbox}(data, mapping = aes(), ..., detail = 30)

\method{shadow_spatial}{bbox}(data, ..., detail = 30)
}
\arguments{
\item{data}{A bounding box generated by \code{\link[sf:st_bbox]{sf::st_bbox()}}}

\item{mapping}{A mapping, created using \link[ggplot2:aes]{aes}.}

\item{...}{Passed to \link[ggplot2:geom_sf]{geom_sf}}

\item{detail}{Passed to \code{\link[sf:st_segmentize]{sf::st_segmentize()}}: the number of line segments
per quadrant of the bounding box. Increase this number for a smoother
projected bounding box.}
}
\description{
To include a bounding box without drawing it, use \code{\link[=shadow_spatial]{shadow_spatial()}} on the
original object.
}
\examples{
library(ggplot2)
load_longlake_data()
ggplot() +
  layer_spatial(sf::st_bbox(longlake_waterdf)) +
  layer_spatial(longlake_depthdf)

# use shadow_spatial() to include the geographic area of an object
# without drawing it
ggplot() +
  shadow_spatial(longlake_waterdf) +
  layer_spatial(longlake_depthdf)

}
