% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous-bs5.R
\name{rgb_bs5}
\alias{rgb_bs5}
\title{Bootstrap 5 color palettes}
\usage{
rgb_bs5(
  palette = c("blue", "indigo", "purple", "pink", "red", "orange", "yellow", "green",
    "teal", "cyan", "gray"),
  n = 10,
  alpha = 1,
  reverse = FALSE
)
}
\arguments{
\item{palette}{Palette type. There are 11 available options:
\itemize{
\item \code{"blue"}
\item \code{"indigo"}
\item \code{"purple"}
\item \code{"pink"}
\item \code{"red"}
\item \code{"orange"}
\item \code{"yellow"}
\item \code{"green"}
\item \code{"teal"}
\item \code{"cyan"}
\item \code{"gray"}
}}

\item{n}{Number of individual colors to be generated.}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{reverse}{Logical. Should the order of the colors be reversed?}
}
\description{
Bootstrap 5 color palettes.
}
\examples{
library("scales")
show_col(pal_bs5("indigo")(10))
show_col(pal_bs5("indigo", n = 30, alpha = 0.6, reverse = TRUE)(30))
}
\references{
\url{https://getbootstrap.com/docs/5.3/customize/color/#all-colors}
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
