% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom-tb.R
\name{stat_fit_tb}
\alias{stat_fit_tb}
\title{Model-fit summary or ANOVA}
\usage{
stat_fit_tb(
  mapping = NULL,
  data = NULL,
  geom = "table_npc",
  method = "lm",
  method.args = list(formula = y ~ x),
  tidy.args = list(),
  tb.type = "fit.summary",
  tb.vars = NULL,
  tb.params = NULL,
  digits = 3,
  p.digits = digits,
  label.x = "center",
  label.y = "top",
  label.x.npc = NULL,
  label.y.npc = NULL,
  position = "identity",
  table.theme = NULL,
  table.rownames = FALSE,
  table.colnames = TRUE,
  table.hjust = 1,
  parse = FALSE,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset, only needed if you want to override the
plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character.}

\item{method.args, tidy.args}{lists of arguments to pass to \code{method} and
to \code{tidy()}.}

\item{tb.type}{character One of "fit.summary", "fit.anova" or "fit.coefs".}

\item{tb.vars, tb.params}{character or numeric vectors, optionally named, used
to select and/or rename the columns or the parameters in the table
returned.}

\item{digits}{integer indicating the number of significant digits to be used
for all numeric values in the table.}

\item{p.digits}{integer indicating the number of decimal places to round
p-values to, with those rounded to zero displayed as the next larger
possible value preceded by "<". If \code{p.digits} is outside the range
1..22 no rounding takes place.}

\item{label.x, label.y}{\code{numeric} Coordinates (in data units) to be used
for absolute positioning of the output. If too short they will be recycled.}

\item{label.x.npc, label.y.npc}{\code{numeric} with range 0..1 or character.
Coordinates to be used for positioning the output, expressed in "normalized
parent coordinates" or character string. If too short they will be
recycled.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{table.theme}{NULL, list or function A 'gridExtra' \code{ttheme}
definition, or a constructor for a \code{ttheme} or NULL for default.}

\item{table.rownames, table.colnames}{logical flag to enable or disabling
printing of row names and column names.}

\item{table.hjust}{numeric Horizontal justification for the core and column
headings of the table.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
A tibble with columns named \code{fm.tb} (a tibble returned by
  \code{tidy()} with possibly renamed and subset columns and rows, within a
  list), \code{fm.tb.type} (copy of argument passed to \code{tb.type}),
  \code{fm.class} (the class of the fitted model object), \code{fm.method}
  (the fit function's name), \code{fm.call} (the call if available), \code{x}
  and \code{y}.

  To explore the values returned by this statistic, which vary depending on
  the model fitting function and model formula we suggest the use of
  \code{\link[gginnards]{geom_debug}}.
}
\description{
\code{stat_fit_tb} fits a model and returns a "tidy" version of
  the model's summary or ANOVA table, using '\code{tidy()} methods from
  packages 'broom', 'broom.mixed', or other 'broom' extensions. The
  annotation is added to the plots in tabular form.
}
\details{
\code{stat_fit_tb()} Applies a model fitting function per panel,
  using the grouping factors from aesthetic mappings in the fitted model.
  This is suitable, for example for analysis of variance used to test for
  differences among groups.

  The argument to \code{method} can be any fit method for which a suitable
  \code{tidy()} method is available, including non-linear regression. Fit
  methods retain their default arguments unless overridden.

  A ggplot statistic receives as data a data frame that is not the one passed
  as argument by the user, but instead a data frame with the variables mapped
  to aesthetics. In other words, it respects the grammar of graphics and
  consequently within arguments passed through \code{method.args} names of
  aesthetics like \eqn{x} and \eqn{y} should be used instead of the original
  variable names. The plot's default \code{data} is used by default, which
  helps ensure that the model is fitted to the same data as plotted in other
  layers.
}
\section{Computed variables}{
 The output of \code{tidy()} is returned as a
  single "cell" in a tibble (i.e., a tibble nested within a tibble). The
  returned \code{data} object contains a single tibble, containing the result
  from a single model fit to all data in a panel. If grouping is present, it
  is ignored in the sense of returning a single table, but the grouping
  aesthetic can be a term in the fitted model.
}

\examples{
# Package 'broom' needs to be installed to run these examples.
# We check availability before running them to avoid errors.
broom.installed <- requireNamespace("broom", quietly = TRUE)

if (broom.installed)
  library(broom)

# data for examples
  x <- c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1)
  covariate <- sqrt(x) + rnorm(9)
  group <- factor(c(rep("A", 4), rep("B", 5)))
  my.df <- data.frame(x, group, covariate)

gginnards.installed  <- requireNamespace("gginnards", quietly = TRUE)

if (gginnards.installed)
  library(gginnards)

## covariate is a numeric or continuous variable
# Linear regression fit summary, all defaults
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb() +
    expand_limits(y = 70)

# we can use geom_debug() and str() to inspect the returned value
# and discover the variables that can be mapped to aesthetics with
# after_stat()
if (broom.installed && gginnards.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(geom = "debug", summary.fun = str) +
    expand_limits(y = 70)

# Linear regression fit summary, with default formatting
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.summary") +
    expand_limits(y = 70)

# Linear regression fit summary, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(digits = 2,
                p.digits = 4,
                tb.params = c("intercept" = 1, "covariate" = 2),
                tb.vars = c(Term = 1, Estimate = 2,
                            "italic(s)" = 3, "italic(t)" = 4,
                            "italic(P)" = 5),
                parse = TRUE) +
    expand_limits(y = 70)

# Linear regression ANOVA table, with default formatting
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.anova") +
    expand_limits(y = 70)

# Linear regression ANOVA table, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.anova",
                tb.params = c("Covariate" = 1, 2),
                tb.vars = c(Effect = 1, d.f. = 2,
                            "M.S." = 4, "italic(F)" = 5,
                            "italic(P)" = 6),
                parse = TRUE) +
    expand_limits(y = 67)

# Linear regression fit coeficients, with default formatting
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.coefs") +
    expand_limits(y = 67)

# Linear regression fit coeficients, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.coefs",
                tb.params = c(a = 1, b = 2),
                tb.vars = c(Term = 1, Estimate = 2)) +
    expand_limits(y = 67)

## x is also a numeric or continuous variable
# Polynomial regression, with default formatting
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(method.args = list(formula = y ~ poly(x, 2))) +
    expand_limits(y = 70)

# Polynomial regression, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(method.args = list(formula = y ~ poly(x, 2)),
                tb.params = c("x^0" = 1, "x^1" = 2, "x^2" = 3),
                tb.vars = c("Term" = 1, "Estimate" = 2, "S.E." = 3,
                            "italic(t)" = 4, "italic(P)" = 5),
                parse = TRUE) +
    expand_limits(y = 70)

## group is a factor or discrete variable
# ANOVA summary, with default formatting
if (broom.installed)
  ggplot(my.df, aes(group, x)) +
    geom_point() +
    stat_fit_tb() +
    expand_limits(y = 70)

# ANOVA table, with default formatting
if (broom.installed)
  ggplot(my.df, aes(group, x)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.anova") +
    expand_limits(y = 70)

# ANOVA table, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(group, x)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.anova",
                tb.vars = c(Effect = "term", "df", "italic(F)" = "statistic",
                            "italic(P)" = "p.value"),
                tb.params = c(Group = 1, Error = 2),
                parse = TRUE)

# ANOVA table, with manual table formatting
# using column names with partial matching
if (broom.installed)
  ggplot(my.df, aes(group, x)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.anova",
                tb.vars = c(Effect = "term", "df", "italic(F)" = "stat",
                            "italic(P)" = "p"),
                tb.params = c(Group = "x", Error = "Resid"),
                parse = TRUE)

# ANOVA summary, with default formatting
if (broom.installed)
  ggplot(my.df, aes(group, x)) +
    geom_point() +
    stat_fit_tb() +
    expand_limits(y = 70)

## covariate is a numeric variable and group is a factor
# ANCOVA (covariate not plotted) ANOVA table, with default formatting
if (broom.installed)
  ggplot(my.df, aes(group, x, z = covariate)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.anova",
                method.args = list(formula = y ~ x + z))

# ANCOVA (covariate not plotted) ANOVA table, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(group, x, z = covariate)) +
    geom_point() +
    stat_fit_tb(tb.type = "fit.anova",
                method.args = list(formula = y ~ x + z),
                tb.vars = c(Effect = 1, d.f. = 2,
                            "M.S." = 4, "italic(F)" = 5,
                            "italic(P)" = 6),
                tb.params = c(Group = 1,
                              Covariate = 2,
                              Error = 3),
                parse = TRUE)

## group is a factor or discrete variable
# t-test, minimal output, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(group, x)) +
    geom_point() +
    stat_fit_tb(method = "t.test",
              tb.vars = c("italic(t)" = "statistic", "italic(P)" = "p.value"),
              parse = TRUE)

# t-test, more detailed output, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(group, x)) +
    geom_point() +
    stat_fit_tb(method = "t.test",
              tb.vars = c("\"Delta \"*italic(x)" = "estimate",
                          "CI low" = "conf.low", "CI high" = "conf.high",
                          "italic(t)" = "statistic", "italic(P)" = "p.value"),
              parse = TRUE) +
    expand_limits(y = 67)

# t-test (equal variances assumed), minimal output, with manual table formatting
if (broom.installed)
  ggplot(my.df, aes(group, x)) +
    geom_point() +
    stat_fit_tb(method = "t.test",
                method.args = list(formula = y ~ x, var.equal = TRUE),
                tb.vars = c("italic(t)" = "statistic", "italic(P)" = "p.value"),
                parse = TRUE)

## covariate is a numeric or continuous variable
# Linear regression using a table theme and non-default position
if (broom.installed)
  ggplot(my.df, aes(covariate, x)) +
    geom_point() +
    stat_fit_tb(table.theme = ttheme_gtlight,
                npcx = "left", npcy = "bottom") +
    expand_limits(y = 35)

}
\seealso{
\code{\link[broom]{broom}}, \code{broom.mixed}, and
  \code{\link[broom]{tidy}} for details on how the tidying of the result of
  model fits is done. See \code{\link[ggpp]{geom_table}} for details on how
  inset tables respond to mapped aesthetics and table themes. For details on
  predefined table themes see \code{\link[ggpp]{ttheme_gtdefault}}.

Other ggplot statistics for model fits: 
\code{\link{stat_fit_augment}()},
\code{\link{stat_fit_deviations}()},
\code{\link{stat_fit_glance}()},
\code{\link{stat_fit_residuals}()},
\code{\link{stat_fit_tidy}()}
}
\concept{ggplot statistics for model fits}
