% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-shape-outcome.r
\name{scale_shape_outcome}
\alias{scale_shape_outcome}
\title{Shape scale for ternary outcomes}
\usage{
scale_shape_outcome(..., name = "Outcome", ns.shape = "circle filled",
  up.shape = "triangle filled", down.shape = "triangle down filled",
  de.shape = "square filled", na.shape = "cross")
}
\arguments{
\item{...}{other named arguments passed to \code{scale_manual}.}

\item{name}{The name of the scale, used for the axis-label.}

\item{ns.shape, down.shape, up.shape, de.shape}{The shapes to use for each
of the three possible outcomes.}

\item{na.shape}{Shape used for NA.}
}
\description{
Manual scales for colour and fill aesthetics with defaults suitable for the
three way outcome from some statistical tests.
}
\details{
These scales only alter the \code{values}, and
  \code{na.value} default arguments of
  \code{scale_shape_manual()}. Please, see
  documentation for \code{\link[ggplot2]{scale_manual}} for details.
}
\examples{

set.seed(12346)
outcome <- sample(c(-1, 0, +1), 50, replace = TRUE)
my.df <- data.frame(x = rnorm(50),
                    y = rnorm(50),
                    outcome2 = outcome2factor(outcome, n.levels = 2),
                    outcome3 = outcome2factor(outcome))

ggplot(my.df, aes(x, y, shape = outcome3)) +
  geom_point() +
  scale_shape_outcome() +
  theme_bw()

ggplot(my.df, aes(x, y, shape = outcome3)) +
  geom_point() +
  scale_shape_outcome(guide = FALSE) +
  theme_bw()

ggplot(my.df, aes(x, y, shape = outcome2)) +
  geom_point(size = 2) +
  scale_shape_outcome() +
  theme_bw()

ggplot(my.df, aes(x, y, shape = outcome3, fill = outcome2)) +
  geom_point() +
  scale_shape_outcome() +
  scale_fill_outcome() +
  theme_bw()

ggplot(my.df, aes(x, y, shape = outcome3, fill = outcome2)) +
  geom_point() +
  scale_shape_outcome(name = "direction") +
  scale_fill_outcome(name = "significance") +
  theme_bw()

}
\seealso{
Other Functions for quadrant and volcano plots: \code{\link{FC_format}},
  \code{\link{geom_quadrant_lines}},
  \code{\link{outcome2factor}},
  \code{\link{scale_colour_outcome}},
  \code{\link{scale_y_Pvalue}},
  \code{\link{stat_quadrant_counts}},
  \code{\link{xy_outcomes2factor}}

Other scales for omics data: \code{\link{outcome2factor}},
  \code{\link{scale_x_logFC}},
  \code{\link{xy_outcomes2factor}}
}
\concept{Functions for quadrant and volcano plots}
\concept{scales for omics data}
