% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes-position.r
\name{aes_position}
\alias{aes_position}
\alias{x}
\alias{y}
\alias{xmin}
\alias{xmax}
\alias{ymin}
\alias{ymax}
\alias{xend}
\alias{yend}
\title{Position related aesthetics: x, y, xmin, xmax, ymin, ymax, xend, yend}
\description{
The following aesthetics can be used to specify the position of elements:
\code{x}, \code{y}, \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax}, \code{xend}, \code{yend}.
}
\details{
\code{x} and \code{y} define the locations of points or of positions along a line
or path.

\code{x}, \code{y} and \code{xend}, \code{yend} define the starting and ending points of
segment and curve geometries.

\code{xmin}, \code{xmax}, \code{ymin}  and \code{ymax} can be used to specify the position of
annotations and to represent rectangular areas.
}
\examples{

# Generate data: means and standard errors of means for prices
# for each type of cut
dmod <- lm(price ~ cut, data = diamonds)
cut <- unique(diamonds$cut)
cuts_df <- data.frame(
  cut,
  predict(dmod, data.frame(cut), se = TRUE)[c("fit", "se.fit")]
)
ggplot(cuts_df) +
  aes(
   x = cut,
   y = fit,
   ymin = fit - se.fit,
   ymax = fit + se.fit,
   colour = cut
  ) +
  geom_pointrange()

# Using annotate
p <- ggplot(mtcars, aes(x = wt, y = mpg)) + geom_point()
p
p + annotate(
  "rect", xmin = 2, xmax = 3.5, ymin = 2, ymax = 25,
  fill = "dark grey", alpha = .5
)

# Geom_segment examples
p + geom_segment(
  aes(x = 2, y = 15, xend = 2, yend = 25),
  arrow = arrow(length = unit(0.5, "cm"))
)
p + geom_segment(
  aes(x = 2, y = 15, xend = 3, yend = 15),
  arrow = arrow(length = unit(0.5, "cm"))
)
p + geom_segment(
  aes(x = 5, y = 30, xend = 3.5, yend = 25),
  arrow = arrow(length = unit(0.5, "cm"))
)

# You can also use geom_segment() to recreate plot(type = "h")
# from base R:
set.seed(1)
counts <- as.data.frame(table(x = rpois(100, 5)))
counts$x <- as.numeric(as.character(counts$x))
with(counts, plot(x, Freq, type = "h", lwd = 10))

ggplot(counts, aes(x = x, y = Freq)) +
  geom_segment(aes(yend = 0, xend = x), size = 10)
}
\seealso{
\itemize{
\item Geoms that commonly use these aesthetics: \code{\link[=geom_crossbar]{geom_crossbar()}},
\code{\link[=geom_curve]{geom_curve()}}, \code{\link[=geom_errorbar]{geom_errorbar()}}, \code{\link[=geom_line]{geom_line()}}, \code{\link[=geom_linerange]{geom_linerange()}},
\code{\link[=geom_path]{geom_path()}}, \code{\link[=geom_point]{geom_point()}}, \code{\link[=geom_pointrange]{geom_pointrange()}}, \code{\link[=geom_rect]{geom_rect()}},
\code{\link[=geom_segment]{geom_segment()}}
\item See also \code{\link[=annotate]{annotate()}} for placing annotations.
}
}
