% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-colour.r, R/zxx.r
\name{scale_colour_continuous}
\alias{scale_colour_continuous}
\alias{scale_fill_continuous}
\alias{scale_colour_binned}
\alias{scale_fill_binned}
\alias{scale_color_continuous}
\alias{scale_color_binned}
\title{Continuous and binned colour scales}
\usage{
scale_colour_continuous(
  ...,
  type = getOption("ggplot2.continuous.colour", default = "gradient")
)

scale_fill_continuous(
  ...,
  type = getOption("ggplot2.continuous.fill", default = "gradient")
)
}
\arguments{
\item{...}{Additional parameters passed on to the scale type}

\item{type}{One of "gradient" (the default) or "viridis" indicating the
colour scale to use}
}
\description{
Colour scales for continuous data default to the values of the
\code{ggplot2.continuous.colour} and \code{ggplot2.continuous.fill} options. If these
options are not present, \code{"gradient"} will be used. See \code{\link[=options]{options()}} for more
information.
}
\section{Color Blindness}{

Many color palettes derived from RGB combinations (like the "rainbow" color
palette) are not suitable to support all viewers, especially those with
color vision deficiencies. Using \code{viridis} type, which is perceptually
uniform in both colour and black-and-white display is an easy option to
ensure good perceptive properties of your visulizations.
The colorspace package offers functionalities
\itemize{
\item to generate color palettes with good perceptive properties,
\item to analyse a given color palette, like emulating color blindness,
\item and to modify a given color palette for better perceptivity.
}

For more information on color vision deficiencies and suitable color choices
see the \href{https://arxiv.org/abs/1903.06490}{paper on the colorspace package}
and references therein.
}

\examples{
v <- ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
geom_tile()
v

v + scale_fill_continuous(type = "gradient")
v + scale_fill_continuous(type = "viridis")

# The above are equivalent to
v + scale_fill_gradient()
v + scale_fill_viridis_c()
}
\seealso{
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}}, \code{\link[=scale_colour_viridis_c]{scale_colour_viridis_c()}},
\code{\link[=scale_colour_steps]{scale_colour_steps()}}, \code{\link[=scale_colour_viridis_b]{scale_colour_viridis_b()}}, \code{\link[=scale_fill_gradient]{scale_fill_gradient()}},
\code{\link[=scale_fill_viridis_c]{scale_fill_viridis_c()}}, \code{\link[=scale_fill_steps]{scale_fill_steps()}}, and \code{\link[=scale_fill_viridis_b]{scale_fill_viridis_b()}}
}
