\name{geom_density}
\alias{geom_density}
\alias{GeomDensity}
\title{geom\_density}
\description{Display a smooth density estimate}
\details{
A smooth density estimate calculated by stat\_densityThis page describes geom\_density, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with geom\_density.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{geom\_density(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{x}: x position (\strong{required}) 
  \item \code{y}: y position (\strong{required}) 
  \item \code{fill}: internal colour 
  \item \code{weight}: observation weight used in statistical transformation 
  \item \code{colour}: border colour 
  \item \code{size}: size 
  \item \code{linetype}: line type 
}
}
\usage{geom_density(mapping=NULL, data=NULL, stat="density", position="identity", ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{stat}{statistic used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{...}{ignored }
}
\seealso{\itemize{
  \item \code{\link{geom_histogram}}: for the histogram
  \item \url{http://had.co.nz/ggplot2/geom_density.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
# See stat_density for examples
}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
