\name{stat_spoke}
\alias{stat_spoke}
\alias{StatSpoke}
\title{stat\_spoke}
\description{Convert angle and radius to xend and yend}
\details{
This page describes stat\_spoke, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with stat\_spoke.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{stat\_spoke(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{x}: x position (\strong{required}) 
  \item \code{y}: y position (\strong{required}) 
  \item \code{angle}: angle (\strong{required}) 
  \item \code{radius}: NULL (\strong{required}) 
  \item \code{xend}: NULL 
  \item \code{yend}: NULL 
}
}
\usage{stat_spoke(mapping=NULL, data=NULL, geom="segment", position="identity", ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{geom}{geometric used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{...}{ignored }
}
\seealso{\itemize{
  \item \url{http://had.co.nz/ggplot2/stat_spoke.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
df <- expand.grid(x = 1:10, y=1:10)
df$angle <- runif(100, 0, 2*pi)
df$speed <- runif(100, 0, 0.5)

qplot(x, y, data=df) + stat_spoke(aes(angle=angle), radius = 0.5)
qplot(x, y, data=df) + stat_spoke(aes(angle=angle, radius=speed))
}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
