% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-serialaxes-quantile.R,
%   R/stat-serialaxes-quantile.R
\name{geom_serialaxes_quantile}
\alias{geom_serialaxes_quantile}
\alias{stat_serialaxes_quantile}
\title{Quantile layer for serial axes coordinate}
\usage{
geom_serialaxes_quantile(
  mapping = NULL,
  data = NULL,
  stat = "serialaxes",
  position = "identity",
  ...,
  axes.sequence = character(0L),
  merge = TRUE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_serialaxes_quantile(
  mapping = NULL,
  data = NULL,
  geom = "serialaxes_quantile",
  position = "identity",
  ...,
  axes.sequence = character(0L),
  merge = TRUE,
  quantiles = seq(0, 1, 0.25),
  scaling = c("variable", "observation", "data", "none"),
  axes.position = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{axes.sequence}{A vector to define the axes sequence. In serial axes coordinate, the sequence can be either
determined in \code{mapping} (function \code{aes()}) or by \code{axes.sequence}. The only difference is that
the \code{mapping} aesthetics will omit the duplicated axes (check examples in \code{\link{geom_serialaxes}}).}

\item{merge}{Should \code{axes.sequence} be merged with mapping aesthetics
as a single mapping \code{uneval} object?}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use display the data}

\item{quantiles}{numeric vector of probabilities with values in [0,1]. (Values up to 2e-14 outside that
range are accepted and moved to the nearby endpoint.)}

\item{scaling}{one of 'variable', 'data', 'observation' or 'none' to specify how the data is scaled.}

\item{axes.position}{A numerical vector to determine the axes sequence position;
the length should be the same with the length of \code{axes.sequence} (or mapping \code{aesthetics}, see examples).}
}
\description{
Draw a quantile layer for serial axes coordinate.
Don't be confused with \code{geom_quantile()} which is a quantile regression. See examples.
}
\examples{
# lower quantile, median and upper quantile
p <- ggplot(iris, mapping = aes(Sepal.Length = Sepal.Length,
                                Sepal.Width = Sepal.Width,
                                Petal.Length = Petal.Length,
                                Petal.Width = Petal.Width)) +
       geom_serialaxes(stat = "dotProduct") +
       geom_serialaxes_quantile(stat = "dotProduct",
                                quantiles = c(0.25, 0.5, 0.75),
                                colour = c("red", "blue", "green"), size = 2)
p

}
\seealso{
\code{\link{geom_density_}}, \code{\link{geom_serialaxes}},
\code{\link{geom_serialaxes_density}}, \code{\link{geom_serialaxes_hist}}
}
