% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density-.R, R/stat-density-.R
\name{geom_density_}
\alias{geom_density_}
\alias{stat_density_}
\title{More general smoothed density estimates}
\usage{
geom_density_(
  mapping = NULL,
  data = NULL,
  stat = "density_",
  position = "identity_",
  ...,
  scale.x = NULL,
  scale.y = c("data", "variable"),
  as.mix = FALSE,
  positive = TRUE,
  adjust = 0.9,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_density_(
  mapping = NULL,
  data = NULL,
  geom = "density_",
  position = "stack_",
  ...,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  n = 512,
  trim = FALSE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Use to override the default connection between
\code{geom_density} and \code{stat_density}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{scale.x}{A length 2 numerical vector. Scale the n coordinates of the points where the density is estimated.}

\item{scale.y}{one of 'data', 'variable' to specify.
\tabular{ll}{ \strong{Type} \tab \strong{Description}
\cr data (default) \tab The density estimates are scaled by the whole data set
\cr variable \tab The density estimates are scaled by each variable
}
If the \code{scale.y} is "data", it is meaningful to compare the density (shape and area) across all groups; else
it is only meaningful to compare the density under each variable.}

\item{as.mix}{Logical. Under each variable, if \code{as.mix = TRUE}, the sum of the density estimate area is mixed and
scaled to maximum 1. The area of each group is proportional to its own count; if \code{as.mix = FALSE}
the area of each group is the same, with maximum 1.}

\item{positive}{If `y` is set as the density estimate, where the smoothed curved is faced to,
right (`positive`) or left (`negative`) as vertical layout; up (`positive`) or down (`negative`) as horizontal layout?}

\item{adjust}{adjust the proportional maximum height of the estimate (density, histogram, ...).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{Use to override the default connection between
\code{geom_density} and \code{stat_density}.}

\item{bw}{The smoothing bandwidth to be used.
If numeric, the standard deviation of the smoothing kernel.
If character, a rule to choose the bandwidth, as listed in
\code{\link[stats:bandwidth]{stats::bw.nrd()}}.}

\item{kernel}{Kernel. See list of available kernels in \code{\link[=density]{density()}}.}

\item{n}{number of equally spaced points at which the density is to be
estimated, should be a power of two, see \code{\link[=density]{density()}} for
details}

\item{trim}{If \code{FALSE}, the default, each density is computed on the
full range of the data. If \code{TRUE}, each density is computed over the
range of that group: this typically means the estimated x values will
not line-up, and hence you won't be able to stack density values.
This parameter only matters if you are displaying multiple densities in
one plot or if you are manually adjusting the scale limits.}
}
\description{
Computes and draws kernel density estimate.
Compared with \code{geom_density()}, it provides more general cases that
accepting `x` and `y`. The `x` (or `y`) is a group variable and  `y` (or `x`) is the target variable to be plotted.
The result is a different density of `y` (`x`) for each value of `x` (`y`).
If only one of `x` or `y` is provided, it will be the target variable (no grouping) and
the standard \code{geom_density()} will be executed.
}
\details{
There are four combinations of \code{scale.y} and \code{as.mix}
\describe{
  \item{\code{scale.y} = "variable" and \code{as.mix} = FALSE}{The density estimates area of each group under the same variable
  is the same and scaled to maximum of 1.}
  \item{\code{scale.y} = "variable" and \code{as.mix} = TRUE}{The density estimates area of each group under the same variable
  is proportional to its own counts (over this variable).}
  \item{\code{scale.y} = "data" and \code{as.mix} = FALSE}{The sum of density estimates area of all group is scaled to maximum of 1.
  The sum of the density area for each variable is proportional to the its counts (over the whole dataset).
  Under each variable, the area of each group is the same.}
  \item{\code{scale.y} = "data" and \code{as.mix} = TRUE}{The sum of density estimates area of all group is scaled to maximum of 1
  and the area of each group is proportional to its own count.}
}
}
\section{Orientation}{
 
This geom treats each axis differently and, thus, can thus have two orientations. Often the orientation is easy to deduce from a combination of the given mappings and the types of positional scales in use. Thus, ggplot2 will by default try to guess which orientation the layer should have. Under rare circumstances, the orientation is ambiguous and guessing may fail. In that case the orientation can be specified directly using the \code{orientation} parameter, which can be either \code{"x"} or \code{"y"}. The value gives the axis that the geom should run along, \code{"x"} being the default orientation you would expect for the geom.
}

\examples{
if(require(dplyr)) {
  mpg \%>\%
    dplyr::filter(drv != "f") \%>\%
    ggplot(mapping = aes(x = drv, y = cty, fill = factor(cyl))) +
    geom_density_(alpha = 0.1)

  # only `x` or `y` is provided
  # that would be equivalent to call function `geom_density()`
  diamonds \%>\%
    dplyr::sample_n(500) \%>\%
    ggplot(mapping = aes(x = price)) +
    geom_density_()

  # density and boxplot
  # set the density estimate on the left
  mpg \%>\%
    dplyr::filter(drv != "f") \%>\%
    ggplot(mapping = aes(x = drv, y = cty, fill = factor(cyl))) +
    geom_density_(alpha = 0.1, scale.y = "data", positive = FALSE) +
    geom_boxplot()

  # x as density
  set.seed(12345)
  suppressWarnings(
    diamonds \%>\%
      dplyr::sample_n(500) \%>\%
      ggplot(mapping = aes(x = price, y = cut, fill = color)) +
      geom_density_(orientation = "x", adjust = 0.25,
                    position = "stack_",
                    scale.y = "variable")
  )
}
# settings of `scale.y` and `as.mix`
\donttest{
ggplots <- lapply(list(
                      list(scale.y = "data", as.mix = TRUE),
                      list(scale.y = "data", as.mix = FALSE),
                      list(scale.y = "variable", as.mix = TRUE),
                      list(scale.y = "variable", as.mix = FALSE)
                    ),
                   function(vars) {
                     scale.y <- vars[["scale.y"]]
                     as.mix <- vars[["as.mix"]]
                     ggplot(mpg,
                            mapping = aes(x = drv, y = cty, fill = factor(cyl))) +
                       geom_density_(alpha = 0.1, scale.y = scale.y, as.mix = as.mix) +
                       labs(title = paste("scale.y =", scale.y),
                            subtitle = paste("as.mix =", as.mix))
                   })
suppressWarnings(
  gridExtra::grid.arrange(grobs = ggplots)
)}

}
\seealso{
\code{\link{geom_density}}, \code{\link{geom_hist_}}
}
