% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_view_1d}
\alias{ggml_view_1d}
\title{1D View with Byte Offset (Graph)}
\usage{
ggml_view_1d(ctx, a, ne0, offset = 0)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Source tensor}

\item{ne0}{Number of elements in the view}

\item{offset}{Byte offset from the start of tensor data}
}
\value{
View tensor
}
\description{
Creates a 1D view of a tensor starting at a byte offset.
The view shares memory with the source tensor.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 100)
# View elements 10-19 (offset = 10 * 4 bytes = 40)
v <- ggml_view_1d(ctx, a, 10, 40)
ggml_free(ctx)
}
}
