% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef}
\alias{ranef}
\alias{random.effects}
\alias{random.effects.default}
\alias{ranef.default}
\alias{ranef.ggmix_gic}
\title{Extract Random Effects}
\usage{
ranef(object, ...)

random.effects(object, ...)

\method{random.effects}{default}(object, ...)

\method{ranef}{default}(object, ...)

\method{ranef}{ggmix_gic}(object, s = "lambda.min", ...)
}
\arguments{
\item{object}{any fitted model object from which random effects estimates can
be extracted. Currently supports "ggmix_gic" objects outputted by the
\code{\link{gic}} function}

\item{...}{other parameters. currently ignored}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which predictions
are required. Default is the value \code{s="lambda.min"} can be used. If
\code{s} is numeric, it is taken as the value(s) of \code{lambda} to be
used.}
}
\value{
a numeric vector of length equal to the number of observations of
  subject-specific random effects
}
\description{
Generic function for extracting the random effects. This is the
  same generic (and same name) defined in the nlme and lme4 package.
}
\details{
For objects of class "ggmix_gic", this function returns the
  subject-specific random effect value for the model which minimizes the GIC
  using the maximum a posteriori principle
}
\examples{
data("admixed")
fit <- ggmix(x = admixed$xtrain, y = admixed$ytrain,
            kinship = admixed$kin_train)
gicfit <- gic(fit)
# random effect at selected value of lambda
plot(ggmix::ranef(gicfit))
# random effects at specific values of lambda
head(ggmix::ranef(gicfit, s = c(0.1,0.2)))
}
\seealso{
\code{\link{gic}}
}
