% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmice.R
\name{ggmice}
\alias{ggmice}
\title{Plot incomplete or imputed data}
\usage{
ggmice(data = NULL, mapping = ggplot2::aes())
}
\arguments{
\item{data}{An incomplete dataset (of class \code{data.frame}), or an object of class \code{\link[mice:mids-class]{mice::mids}}.}

\item{mapping}{A list of aesthetic mappings created with \code{\link[ggplot2:aes]{ggplot2::aes()}}.}
}
\value{
An object of class \code{\link[ggplot2:ggplot]{ggplot2::ggplot}}.
}
\description{
Plot incomplete or imputed data
}
\examples{
dat <- mice::nhanes
ggmice(dat, ggplot2::aes(x = age, y = bmi)) + ggplot2::geom_point()
}
\seealso{
See the \code{ggmice} vignette to use the \code{ggmice()} function on
\href{https://amices.org/ggmice/articles/ggmice.html#the-ggmice-function}{incomplete data}
or \href{https://amices.org/ggmice/articles/ggmice.html#the-ggmice-function-1}{imputed data}.
}
