% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{linear}
\alias{linear}
\title{Simulated data for a continuous linear regression and its MCMC samples}
\format{
Three objects, namely:
\describe{
  \item{s}{A coda object containing posterior distributions of the intercept (beta[1]) and slope (beta[2]) of a linear regression with simulated data.}
  \item{s.y.rep}{A coda object containing simulated values from the posterior predictive distribution of the outcome of a linear regression with simulated data (y ~ N(mu, sigma); mu = beta[1] + beta[2] * X; y.rep ~ N(mu, sigma); where y.rep is a replicated outcome, originally missing data).}
  \item{y}{A numeric vector containing the observed values of the outcome in the linear regression with simulated data.}
}
}
\source{
Simulated data for ggmcmc
}
\usage{
data(linear)
}
\description{
Simulate a dataset with one explanatory variable and one continuous outcome variable using (y ~ dnorm(mu, sigma); mu = beta[1] + beta[2] * X). The data loads three objects: the observed y values, a coda object containing simulated values from the posterior distribution of the intercept and slope of a linear regression, and a coda object containing simulated values from the posterior predictive distribution. The purpose of the dataset is only to show the possibilities of the ggmcmc package.
}
\examples{
data(linear)
str(s)
str(s.y.rep)
str(y)
}
\keyword{datasets}
