% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_text_interactive.R
\name{geom_text_interactive}
\alias{geom_text_interactive}
\title{interactive textual annotations.}
\usage{
geom_text_interactive(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", parse = FALSE, ..., nudge_x = 0, nudge_y = 0,
  check_overlap = FALSE, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{The aesthetic mapping, see \code{\link[ggplot2]{geom_point}}.}

\item{data}{A data frame, see \code{\link[ggplot2]{geom_point}}.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string, see \code{\link[ggplot2]{geom_point}}.}

\item{position}{Postion adjustment, see \code{\link[ggplot2]{geom_point}}.}

\item{parse}{See \code{\link[ggplot2]{geom_point}}.}

\item{...}{other arguments passed on to layer. See \code{\link[ggplot2]{geom_point}}.}

\item{nudge_x, nudge_y}{See \code{\link[ggplot2]{geom_point}}.}

\item{check_overlap}{See \code{\link[ggplot2]{geom_point}}.}

\item{na.rm}{See \code{\link[ggplot2]{geom_point}}.}

\item{show.legend}{See \code{\link[ggplot2]{geom_point}}.}

\item{inherit.aes}{See \code{\link[ggplot2]{geom_point}}.}
}
\description{
The geometry is based on \code{\link[ggplot2]{geom_text}}.
See the documentation for those functions for more details.
}
\examples{
# add interactive polygons to a ggplot -------
## the data
dataset = mtcars
dataset$label = row.names(mtcars)

dataset$tooltip = paste0( "cyl: ", dataset$cyl, "<br/>",
       "gear: ", dataset$gear, "<br/>",
       "carb: ", dataset$carb)

## the plot
gg_text = ggplot(dataset,
                 aes(x = mpg, y = wt, label = label,
                     color = qsec,
                     tooltip = tooltip, data_id = label ) ) +
  geom_text_interactive() +
  coord_cartesian(xlim = c(0,50))

## display the plot
ggiraph(code = {print(gg_text)}, hover_css = "fill:#FF4C3B;font-style:italic;")
}
\seealso{
\code{\link{ggiraph}}
}
