% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_box.R
\name{geom_box}
\alias{geom_box}
\title{Flexible rectangles}
\usage{
geom_box(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  radius = NULL
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{radius}{A \code{\link[grid:unit]{grid::unit}} object of length 1 or \code{numeric(1)} to set
rounded corners. If \code{NULL} (default), no rounded corners are applied. If
\code{numeric(1)}, it is interpreted as millimetres. Does not work under
non-linear coordinates.}
}
\value{
A ggplot2 \code{Layer} object that can be added to a plot.
}
\description{
The \code{geom_box()} function offers a more flexible variant of \code{geom_rect()} and
\code{geom_tile()}. Instead of exclusively working with the \verb{(x/y)min}/\verb{(x/y)max}
\emph{or} \code{(x/y)}/\code{(width/height)} aesthetics, any two out of these four
aesthetics suffice to define a rectangle.
}
\examples{
# Combine any two position aesthetics
df <- data.frame(
  x = c(1.5, 3.5), xmin = c(1, 2),
  y = c(1.5, 2.5), ymin = c(1, 2)
)
ggplot(df) +
  geom_box(aes(x = x, xmin = xmin, y = y, ymin = ymin))

# Works with partial information for position, as long as two aesthetics
# are complete for any observation.
df <- data.frame(
  x = c(1.5, NA, 4),   xmin = c(1, 2, NA), width = c(NA, 3, 2),
  y = c(1.5, 2.5, NA), ymin = c(NA, 2, 3), height = c(1, NA, 3)
)
ggplot(df) +
  geom_box(aes(x = x, xmin = xmin, y = y, ymin = ymin,
               width = width, height = height))

# Set radius for rounded corners
ggplot() +
  geom_box(
    aes(x = 1:3, width = rep(1, 3),
        y = 1:3, height = 3:1),
    radius = 5
  )
}
