% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gglegend.R
\name{gglegend}
\alias{gglegend}
\title{gglegend}
\usage{
gglegend(mapping, data, geom, p = NULL)
}
\arguments{
\item{mapping}{aes mapping for the 'geom'. The first mapping should be the one for the legend,
while others maybe needed for the 'geom' (e.g., label for geom_text).}

\item{data}{input data frame. If users want to mapping 'VALUE' to 'colour',
the input data should contains 'VALUE' and 'colour' (actual value, e.g., 'red' and 'blue') variable.}

\item{geom}{a geom to plot the data for generating the legend and the geom will be plotted invisible.}

\item{p}{a ggplot object. If NULL, the 'last_plot()' will be used.}
}
\value{
a ggplot object
}
\description{
add manual setting legend
}
\details{
add additional legend to a ggplot
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(mpg, disp)) + geom_point()
data <- data.frame(colour = c("red",  "blue"), VALUE = c("A", "B"))
gglegend(aes(colour = VALUE, label=VALUE), data, geom_text, p)
}
\author{
Guangchuang Yu
}
