% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fortify_glmnet.R
\name{autoplot.glmnet}
\alias{autoplot.glmnet}
\title{Autoplot \code{glmnet::glmnet}}
\usage{
\method{autoplot}{glmnet}(object, xvar = c("norm", "lambda", "dev"),
  label.n = 7, label = TRUE, label.label = "Df", label.colour = NULL,
  label.alpha = NULL, label.size = NULL, label.angle = NULL,
  label.family = NULL, label.fontface = NULL, label.lineheight = NULL,
  label.hjust = NULL, label.vjust = NULL, xlim = c(NA, NA), ylim = c(NA,
  NA), log = "", main = NULL, xlab = NULL, ylab = "Coefficients",
  asp = NULL, ...)
}
\arguments{
\item{object}{\code{glmnet::glmnet} instance}

\item{xvar}{values to be dranw on the X axis. Either "norm" (L1-norm), "lambda" (log-lambda sequence) or "dev" (percent deviance)}

\item{label.n}{Number of Df labels}

\item{label}{Logical value whether to display labels}

\item{label.label}{Column name used for label text}

\item{label.colour}{Colour for text labels}

\item{label.alpha}{Alpha for text labels}

\item{label.size}{Size for text labels}

\item{label.angle}{Angle for text labels}

\item{label.family}{Font family for text labels}

\item{label.fontface}{Fontface for text labels}

\item{label.lineheight}{Lineheight for text labels}

\item{label.hjust}{Horizontal adjustment for text labels}

\item{label.vjust}{Vertical adjustment for text labels}

\item{xlim}{limits for x axis}

\item{ylim}{limits for y axis}

\item{log}{which variables to log transform ("x", "y", or "xy")}

\item{main}{character vector or expression for plot title}

\item{xlab}{character vector or expression for x axis label}

\item{ylab}{character vector or expression for y axis label}

\item{asp}{the y/x aspect ratio}

\item{...}{other arguments passed to methods}
}
\value{
ggplot
}
\description{
Autoplot \code{glmnet::glmnet}
}
\examples{
autoplot(glmnet::glmnet(data.matrix(Orange[-3]), data.matrix(Orange[3])))
}

