% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstance.R
\name{gf_boxploth}
\alias{gf_boxploth}
\title{Formula interface to geom_boxploth()}
\usage{
gf_boxploth(object = NULL, gformula = NULL, data = NULL, alpha,
  color, fill, group, linetype, size, coef, outlier.color = NULL,
  outlier.fill = NULL, outlier.shape = 19, outlier.size = 1.5,
  outlier.stroke = 0.5, outlier.alpha = NULL, notch = FALSE,
  notchwidth = 0.5, varwidth = FALSE, xlab, ylab, title, subtitle,
  caption, geom = "boxploth", stat = "boxploth", position = "dodgev",
  show.legend = NA, show.help = NULL, inherit = TRUE,
  environment = parent.frame(), ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{y ~ x}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{fill}{A color for filling, or a formula used for mapping fill.}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{coef}{Length of the whiskers as multiple of IQR. Defaults to 1.5.}

\item{outlier.color}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.fill}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.shape}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.size}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.stroke}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.alpha}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{notch}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, make a notched box plot. Notches are used to compare groups;
if the notches of two boxes do not overlap, this suggests that the medians
are significantly different.}

\item{notchwidth}{For a notched box plot, width of the notch relative to
the body (default 0.5)}

\item{varwidth}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{Use to override the default connection between
\code{geom_boxplot} and \code{stat_boxplot}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}
}
\value{
a gg object
}
\description{
Horizontal version of \code{\link[ggplot2]{geom_boxplot}()}.
}
\section{Specifying plot attributes}{


Positional attributes (a.k.a, aesthetics) are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{


Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}

\examples{
if (require(mosaicData)) {
  gf_boxploth(substance ~ age, data = HELPrct)
  gf_boxploth(substance ~ age, data = HELPrct, varwidth = TRUE)
  gf_boxploth(substance ~ age, data = HELPrct, color = ~ sex)
  gf_boxploth(substance ~ age, data = HELPrct, color = ~ sex, outlier.color = "gray50")
  # longer whiskers
  gf_boxploth(substance ~ age, data = HELPrct, color = ~ sex, coef = 2)
  # Note: height for boxplots is full width of box.
  #   For jittering, it is the half-height.
  gf_boxploth(substance ~ age | sex, data = HELPrct, coef = 5, height = 0.4) \%>\%
    gf_jitter(height = 0.2, alpha = 0.3)
  # move boxplots away a bit by adjusting dodge
  gf_boxploth(substance ~ age, data = HELPrct, color = ~ sex,
    position = position_dodgev(height = 0.9))
}
}
\seealso{
\link[ggplot2:geom_boxplot]{ggstance::geom_boxploth()}, \code{\link[=fivenum]{fivenum()}}, \code{\link[=df_stats]{df_stats()}}
}
