% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_hierarchical.R
\name{h.samples.dmc}
\alias{h.samples.dmc}
\title{Set up a DMC Sample with Multiple Participants}
\usage{
h.samples.dmc(nmc, p.prior = NULL, data = NULL, pp.prior = NULL,
  samples = NULL, thin = 1, theta1 = NULL, phi1 = NULL,
  start.prior = NULL, hstart.prior = NULL, add = FALSE, rp = 0.001,
  setting = NULL, verbose = FALSE)
}
\arguments{
\item{nmc}{number of Markov Chain Monte Carlo iteration}

\item{p.prior}{prior distribution setting}

\item{data}{a model data instance created by \code{data.model.dmc}}

\item{pp.prior}{prior distribution setting, hyper level}

\item{samples}{a DMC posterior sample}

\item{thin}{thinning length. Default 1}

\item{theta1}{A user supplied initial theta cube}

\item{phi1}{A user supplied initial phi cube}

\item{start.prior}{A user supplied (different) prior distribution setting}

\item{hstart.prior}{A user supplied (different) hyper-prior
distribution setting}

\item{add}{whether add new MCMC iteration on top of previous DMC sample}

\item{rp}{a DEMCMC tuning parameter}

\item{setting}{a list container to store all DMC setting}

\item{verbose}{whether to print debugging information}
}
\description{
\code{h.samples.dmc} initialise a DMC object with each particpant as a list
element in a list. A participant is himself/herself a list element, carrying
the DMC setting, such as theta, summed_log_likelihood, etc.
}
\examples{
## Set up a DDM Model, rate effect of factor F
m1 <- model.dmc(
  p.map     = list(a="1",v="F",z="1",d="1",sz="1",sv="1",t0="1",st0="1"),
  match.map = list(M=list(s1="r1",s2="r2")),
  factors=list(S=c("s1","s2"), F=c("f1","f2")),
  constants = c(st0=0,d=0),
  responses = c("r1","r2"),
  type = "rd")

## Population distribution
pop.mean  <- c(a=2,   v.f1=2.5, v.f2=1.5, z=0.5, sz=0.3, sv=1,  t0=0.3)
pop.scale <- c(a=0.5, v.f1=.5,  v.f2=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05)
pop.prior <- prior.p.dmc(
  dists = rep("tnorm",7),
  p1    = pop.mean,
  p2    = pop.scale,
  lower = c(0,-5, -5, 0, 0, 0, 0),
  upper = c(5, 7,  7, 2, 2, 2, 2))

##  Check population distributions
plot_priors(pop.prior)

## Simulate some data
dat <- h.simulate.dmc(m1, nsim=20, ns=4, p.prior=pop.prior)
mdi <- data.model.dmc(dat, m1)
head(dat)
##    S  F  R        RT
## 1 s1 f1 r1 0.9227881
## 2 s1 f1 r1 0.7878554
## 3 s1 f1 r1 0.4814711
## 4 s1 f1 r1 0.6864110
## 5 s1 f1 r1 0.5068179
## 6 s1 f1 r1 0.6356547

## Take a look at true parameters
ps <- round( attr(dat, "parameters"), 2)
ps
##      a v.f1 v.f2    z   sz   sv   t0
## 1 2.83 2.91 1.41 0.66 0.30 0.65 0.30
## 2 2.37 2.42 2.24 0.48 0.28 1.14 0.31
## 3 1.91 2.49 0.98 0.74 0.33 1.20 0.18
## 4 2.14 2.67 2.34 0.65 0.31 1.74 0.27

## FIT FIXED EFFECTS
## specify a broader prior than the true population distribution
p.prior <- prior.p.dmc(
  dists= rep("tnorm", length(pop.mean)),
  p1=pop.mean,
  p2=pop.scale*5,
  lower=c(0,-5, -5, 0, 0, 0, 0),
  upper=c(5, 7,  7, 2, 2, 2, 2))

## Set up multiple participant DMC sample
samples0 <- h.samples.dmc(nmc=100, p.prior=p.prior, data=mdi, thin=1)

## Add 400 more iterations and change thinning length to 2
samples1 <- h.samples.dmc(nmc=100, p.prior=p.prior, samples=samples0,
thin=2, add=TRUE)

samples1[[1]]$nmc
## [1] 200
}
\keyword{h.samples.dmc}

