% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_mejr}
\alias{theme_mejr}
\title{Custom ggplot2 theme}
\usage{
theme_mejr(base_size = 11, base_family = getOption("ggdistribute.font"),
  black = 67, margin_add = 2, debug = FALSE, FUN = NULL, ...)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{black}{Values from 0 to 255, indicating the darkest line and
text colors (255).}

\item{margin_add}{additive adjustment of margin spacing and tick length (in "pt"
units). May be positive or negative.}

\item{debug}{Add debug info to text.}

\item{FUN}{Call a function before returning the theme elements.}

\item{...}{Arguments passed to \code{FUN}}
}
\description{
A complete, minimal theme to be used with the \code{ggplot2} package
}
\details{
You can use \code{theme_update} to change some aspect of this theme after
using \code{theme_set}.
}
\examples{
\donttest{
library(ggplot2)

theme_set(theme_mejr(debug = TRUE))
example_plot()

theme_set(theme_mejr())
theme_update(axis.text = element_blank()) # any updates can go here
example_plot()
}
}
\seealso{
\link{mejr_geom_defaults}, \link[ggplot2:theme_update]{ggplot2::theme_update}, \link[ggplot2:theme_set]{ggplot2::theme_set}
}
