% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_colour_ramp.R
\name{partial_colour_ramp}
\alias{partial_colour_ramp}
\title{Partial colour ramp (datatype)}
\usage{
partial_colour_ramp(amount = double(), from = "white")
}
\arguments{
\item{amount}{Numeric vector between \code{0} and \code{1} giving amounts to ramp
the colour. \code{0} corresponds to the colour \code{from}.}

\item{from}{Character vector giving colours to ramp from.}
}
\value{
A \link[vctrs:new_rcrd]{vctrs::rcrd} of class \code{"ggdist_partial_colour_ramp"} with fields
\code{"amount"} and \code{"from"}.
}
\description{
A representation of a partial ramp between two colours: the origin colour
(\code{from}) and the distance from the origin colour to the target colour
(\code{amount}, a value between \code{0} and \code{1}). The target colour of the ramp
can be filled in later using \code{ramp_colours()}, producing a colour.
}
\details{
This datatype is used by \link{scale_colour_ramp} to create ramped colours in
\pkg{ggdist} geoms. It is a \link[vctrs:new_rcrd]{vctrs::rcrd} datatype with two fields:
\code{"amount"}, the amount to ramp, and \code{"from"}, the colour to ramp from.

Colour ramps can be applied (i.e. translated into colours) using
\code{\link[=ramp_colours]{ramp_colours()}}, which can be used with \code{\link[=partial_colour_ramp]{partial_colour_ramp()}}
to implement geoms that make use of \code{colour_ramp} or \code{fill_ramp} scales.
}
\examples{
pcr = partial_colour_ramp(c(0, 0.25, 0.75, 1), "red")
pcr

ramp_colours("blue", pcr)
}
\seealso{
Other colour ramp functions: 
\code{\link{guide_rampbar}()},
\code{\link{ramp_colours}()},
\code{\link{scale_colour_ramp}}
}
\author{
Matthew Kay
}
\concept{colour ramp functions}
