% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_dotsinterval.R
\name{geom_dotsinterval}
\alias{geom_dotsinterval}
\title{Automatic dotplot + point + interval meta-geom}
\usage{
geom_dotsinterval(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  binwidth = NA,
  dotsize = 1.07,
  stackratio = 1,
  layout = "bin",
  overlaps = "nudge",
  smooth = "none",
  overflow = "keep",
  verbose = FALSE,
  orientation = NA,
  interval_size_domain = c(1, 6),
  interval_size_range = c(0.6, 1.4),
  fatten_point = 1.8,
  show_slab = TRUE,
  show_point = TRUE,
  show_interval = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.
Setting this equal to \code{"dodge"} (\code{\link[=position_dodge]{position_dodge()}}) or \code{"dodgejust"} (\code{\link[=position_dodgejust]{position_dodgejust()}}) can be useful if
you have overlapping geometries.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. These are often aesthetics, used to set an aesthetic
to a fixed value, like \code{colour = "red"} or \code{linewidth = 3} (see \strong{Aesthetics}, below). They may also be
parameters to the paired geom/stat.}

\item{binwidth}{The bin width to use for laying out the dots.
One of:
\itemize{
\item \code{NA} (the default): Dynamically select the bin width based on the
size of the plot when drawn. This will pick a \code{binwidth} such that the
tallest stack of dots is at most \code{scale} in height (ideally exactly \code{scale}
in height, though this is not guaranteed).
\item A length-1 (scalar) numeric or \link{unit} object giving the exact bin width.
\item A length-2 (vector) numeric or \link{unit} object giving the minimum and maximum
desired bin width. The bin width will be dynamically selected within
these bounds.
}

If the value is numeric, it is assumed to be in units of data. The bin width
(or its bounds) can also be specified using \code{\link[=unit]{unit()}}, which may be useful if
it is desired that the dots be a certain point size or a certain percentage of
the width/height of the viewport. For example, \code{unit(0.1, "npc")} would make
dots that are \emph{exactly} 10\% of the viewport size along whichever dimension the
dotplot is drawn; \code{unit(c(0, 0.1), "npc")} would make dots that are \emph{at most}
10\% of the viewport size (while still ensuring the tallest stack is less than
or equal to \code{scale}).}

\item{dotsize}{The width of the dots relative to the \code{binwidth}. The default,
\code{1.07}, makes dots be just a bit wider than the bin width, which is a
manually-tuned parameter that tends to work well with the default circular
shape, preventing gaps between bins from appearing to be too large visually
(as might arise from dots being \emph{precisely} the \code{binwidth}). If it is desired
to have dots be precisely the \code{binwidth}, set \code{dotsize = 1}.}

\item{stackratio}{The distance between the center of the dots in the same
stack relative to the dot height. The default, \code{1}, makes dots in the same
stack just touch each other.}

\item{layout}{The layout method used
for the dots: \itemize{
\item \code{"bin"} (default): places dots on the off-axis at the midpoint of their bins as in the classic Wilkinson dotplot.
This maintains the alignment of rows and columns in the dotplot. This layout is slightly different from the
classic Wilkinson algorithm in that: (1) it nudges bins slightly to avoid overlapping bins and (2) if
the input data are symmetrical it will return a symmetrical layout.
\item \code{"weave"}: uses the same basic binning approach of \code{"bin"}, but places dots in the off-axis at their actual
positions (unless \code{overlaps = "nudge"}, in which case overlaps may be nudged out of the way). This maintains
the alignment of rows but does not align dots within columns.
\item \code{"hex"}: uses the same basic binning approach of \code{"bin"}, but alternates placing dots \code{+ binwidth/4} or
\code{- binwidth/4} in the off-axis from the bin center. This allows hexagonal packing by setting a \code{stackratio}
less than 1 (something like \code{0.9} tends to work).
\item \code{"swarm"}: uses the \code{"compactswarm"} layout from \code{\link[beeswarm:beeswarm]{beeswarm::beeswarm()}}. Does not maintain alignment of rows or
columns, but can be more compact and neat looking, especially for sample data (as opposed to quantile
dotplots of theoretical distributions, which may look better with \code{"bin"}, \code{"weave"}, or \code{"hex"}).
}}

\item{overlaps}{How to handle overlapping dots or bins in the \code{"bin"},
\code{"weave"}, and \code{"hex"} layouts (dots never overlap in the \code{"swarm"} layout).
For the purposes of this argument, dots are only considered to be overlapping
if they would be overlapping when \code{dotsize = 1} and \code{stackratio = 1}; i.e.
if you set those arguments to other values, overlaps may still occur.
One of: \itemize{
\item \code{"keep"}: leave overlapping dots as they are. Dots may overlap
(usually only slightly) in the \code{"bin"}, \code{"weave"}, and \code{"hex"} layouts.
\item \code{"nudge"}: nudge overlapping dots out of the way. Overlaps are avoided
using a constrained optimization which minimizes the squared distance of
dots to their desired positions, subject to the constraint that adjacent
dots do not overlap.
}}

\item{smooth}{Smoother to apply to dot positions.
One of:
\itemize{
\item A function that takes a numeric vector of dot positions and returns a
smoothed version of that vector, such as \code{smooth_bounded()},
\code{smooth_unbounded()}, smooth_discrete()\verb{, or }smooth_bar()`.
\item A string indicating what smoother to use, as the suffix to a function
name starting with \code{smooth_}; e.g. \code{"none"} (the default) applies
\code{smooth_none()}, which simply returns the given vector without
applying smoothing.
}

Smoothing is most effective when the smoother is matched to the support of
the distribution; e.g. using \code{smooth_bounded(bounds = ...)}.}

\item{overflow}{How to handle overflow of dots beyond the extent of the geom
when a minimum \code{binwidth} (or an exact \code{binwidth}) is supplied.
One of:
\itemize{
\item \code{"keep"}: Keep the overflow, drawing dots outside the geom bounds.
\item \code{"compress"}: Compress the layout. Reduces the \code{binwidth} to the size necessary
to keep the dots within bounds, then adjusts \code{stackratio} and \code{dotsize} so that
the apparent dot size is the user-specified minimum \code{binwidth} times the
user-specified \code{dotsize}.
}

If you find the default layout has dots that are too small, and you are okay
with dots overlapping, consider setting \code{overflow = "compress"} and supplying
an exact or minimum dot size using \code{binwidth}.}

\item{verbose}{If \code{TRUE}, print out the bin width of the dotplot. Can be useful
if you want to start from an automatically-selected bin width and then adjust it
manually. Bin width is printed both as data units and as normalized parent
coordinates or \code{"npc"}s (see \code{\link[=unit]{unit()}}). Note that if you just want to scale the
selected bin width to fit within a desired area, it is probably easier to use
\code{scale} than to copy and scale \code{binwidth} manually, and if you just want to
provide constraints on the bin width, you can pass a length-2 vector to \code{binwidth}.}

\item{orientation}{Whether this geom is drawn horizontally or vertically. One of:
\itemize{
\item \code{NA} (default): automatically detect the orientation based on how the aesthetics
are assigned. Automatic detection works most of the time.
\item \code{"horizontal"} (or \code{"y"}): draw horizontally, using the \code{y} aesthetic to identify different
groups. For each group, uses the \code{x}, \code{xmin}, \code{xmax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
\item \code{"vertical"} (or \code{"x"}): draw vertically, using the \code{x} aesthetic to identify different
groups. For each group, uses the \code{y}, \code{ymin}, \code{ymax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
}
For compatibility with the base ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias
for \code{"vertical"} and \code{"y"} as an alias for \code{"horizontal"} (\pkg{ggdist} had an \code{orientation} parameter
before base ggplot did, hence the discrepancy).}

\item{interval_size_domain}{A length-2 numeric vector giving the minimum and maximum of the values of the \code{size} and \code{linewidth} aesthetics that will be
translated into actual sizes for intervals drawn according to \code{interval_size_range} (see the documentation
for that argument.)}

\item{interval_size_range}{A length-2 numeric vector. This geom scales the raw size aesthetic values when drawing interval and point
sizes, as they tend to be too thick when using the default settings of \code{\link[=scale_size_continuous]{scale_size_continuous()}}, which give
sizes with a range of \code{c(1, 6)}. The \code{interval_size_domain} value indicates the input domain of raw size
values (typically this should be equal to the value of the \code{range} argument of the \code{\link[=scale_size_continuous]{scale_size_continuous()}}
function), and \code{interval_size_range} indicates the desired output range of the size values (the min and max of
the actual sizes used to draw intervals). Most of the time it is not recommended to change the value of this
argument, as it may result in strange scaling of legends; this argument is a holdover from earlier versions
that did not have size aesthetics targeting the point and interval separately. If you want to adjust the
size of the interval or points separately, you can also use the \code{linewidth} or \code{point_size}
aesthetics; see \link{scales}.}

\item{fatten_point}{A multiplicative factor used to adjust the size of the point relative to the size of the
thickest interval line. If you wish to specify point sizes directly, you can also use the \code{point_size}
aesthetic and \code{\link[=scale_point_size_continuous]{scale_point_size_continuous()}} or \code{\link[=scale_point_size_discrete]{scale_point_size_discrete()}}; sizes
specified with that aesthetic will not be adjusted using \code{fatten_point}.}

\item{show_slab}{Should the slab portion of the geom be drawn?}

\item{show_point}{Should the point portion of the geom be drawn?}

\item{show_interval}{Should the interval portion of the geom be drawn?}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Geom} or \link[ggplot2:ggplot2-ggproto]{ggplot2::Stat} representing a dotplot or combined dotplot+interval geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
This meta-geom supports drawing combinations of dotplots, points, and intervals.
Geoms and stats based on \code{\link[=geom_dotsinterval]{geom_dotsinterval()}} create dotplots that automatically determine a bin width that
ensures the plot fits within the available space. They also ensure dots do not overlap, and allow
the generation of quantile dotplots using the \code{quantiles} argument to \code{\link[=stat_dotsinterval]{stat_dotsinterval()}}/\code{\link[=stat_dots]{stat_dots()}}.
Generally follows the naming scheme and
arguments of the \code{\link[=geom_slabinterval]{geom_slabinterval()}} and \code{\link[=stat_slabinterval]{stat_slabinterval()}} family of
geoms and stats.
}
\details{
The \emph{dots} family of stats and geoms are similar to \code{\link[=geom_dotplot]{geom_dotplot()}} but with a number of differences:

\itemize{
\item Dots geoms act like slabs in \code{\link[=geom_slabinterval]{geom_slabinterval()}} and can be given x positions (or y positions when
in a horizontal orientation).
\item Given the available space to lay out dots, the dots geoms will automatically determine how many bins to
use to fit the available space.
\item Dots geoms use a dynamic layout algorithm that lays out dots from the center out if the input data are
symmetrical, guaranteeing that symmetrical data results in a symmetrical plot. The layout algorithm also prevents
dots from overlapping each other.
\item The shape of the dots in these geoms can be changed using the \code{slab_shape} aesthetic (when using the
\code{dotsinterval} family) or the \code{shape} or \code{slab_shape} aesthetic (when using the \code{dots} family)
}

Stat and geoms include in this family include:
\itemize{
\item \code{\link[=geom_dots]{geom_dots()}}: dotplots on raw data. Ensures the dotplot fits within available space by reducing the size
of the dots automatically (may result in very small dots).
\item \code{\link[=geom_swarm]{geom_swarm()}} and \code{\link[=geom_weave]{geom_weave()}}: dotplots on raw data with defaults intended to create "beeswarm" plots.
Used \code{side = "both"} by default, and sets the default dot size to the same size as \code{\link[=geom_point]{geom_point()}}
(\code{binwidth = unit(1.5, "mm")}), allowing dots to overlap instead of getting very small.
\item \code{\link[=stat_dots]{stat_dots()}}: dotplots on raw data, \pkg{distributional} objects, and \code{\link[posterior:rvar]{posterior::rvar()}}s
\item \code{\link[=geom_dotsinterval]{geom_dotsinterval()}}: dotplot + interval plots on raw data with already-calculated
intervals (rarely useful directly)
\item \code{\link[=stat_dotsinterval]{stat_dotsinterval()}}: dotplot + interval plots on raw data, \pkg{distributional} objects,
and \code{\link[posterior:rvar]{posterior::rvar()}}s (will calculate intervals for you)
}

\code{\link[=stat_dots]{stat_dots()}} and \code{\link[=stat_dotsinterval]{stat_dotsinterval()}}, when used with the \code{quantiles} argument,
are particularly useful for constructing quantile dotplots, which can be an effective way to communicate uncertainty
using a frequency framing that may be easier for laypeople to understand (Kay et al. 2016, Fernandes et al. 2018).

\strong{To visualize sample data}, such as a data distribution, samples from a
bootstrap distribution, or a Bayesian posterior, you can supply samples to
the \code{x} or \code{y} aesthetic.

\strong{To visualize analytical distributions}, you can use the \code{xdist} or \code{ydist}
aesthetic. For historical reasons, you can also use \code{dist} to specify the distribution, though
this is not recommended as it does not work as well with orientation detection.
These aesthetics can be used as follows:
\itemize{
\item \code{xdist}, \code{ydist}, and \code{dist} can be any distribution object from the \href{https://pkg.mitchelloharawild.com/distributional/}{distributional}
package (\code{\link[=dist_normal]{dist_normal()}}, \code{\link[=dist_beta]{dist_beta()}}, etc) or can be a \code{\link[posterior:rvar]{posterior::rvar()}} object.
Since these functions are vectorized,
other columns can be passed directly to them in an \code{\link[=aes]{aes()}} specification; e.g.
\code{aes(dist = dist_normal(mu, sigma))} will work if \code{mu} and \code{sigma} are columns in the
input data frame.
\item \code{dist} can be a character vector giving the distribution name. Then the  \code{arg1}, ... \code{arg9}
aesthetics (or \code{args} as a list column) specify distribution arguments. Distribution names
should correspond to R functions that have \code{"p"}, \code{"q"}, and \code{"d"} functions; e.g. \code{"norm"}
is a valid distribution name because R defines the \code{\link[=pnorm]{pnorm()}}, \code{\link[=qnorm]{qnorm()}}, and \code{\link[=dnorm]{dnorm()}}
functions for Normal distributions.

See the \code{\link[=parse_dist]{parse_dist()}} function for a useful way to generate \code{dist} and \code{args}
values from human-readable distribution specs (like \code{"normal(0,1)"}). Such specs are also
produced by other packages (like the \code{brms::get_prior} function in brms); thus,
\code{\link[=parse_dist]{parse_dist()}} combined with the stats described here can help you visualize the output
of those functions.
}
}
\section{Aesthetics}{

The dots+interval \code{stat}s and \code{geom}s have a wide variety of aesthetics that control
the appearance of their three sub-geometries: the \strong{dots} (aka the \strong{slab}), the
\strong{point}, and the \strong{interval}.

\strong{Positional aesthetics}

\itemize{
\item{\code{x}: x position of the geometry}
\item{\code{y}: y position of the geometry}
}

\strong{Dots-specific (aka Slab-specific) aesthetics}

\itemize{
\item{\code{family}: The font family used to draw the dots.}
\item{\code{order}: The order in which data points are stacked within bins. Can be used to create the effect of
"stacked" dots by ordering dots according to a discrete variable. If omitted (\code{NULL}), the
value of the data points themselves are used to determine stacking order. Only applies when
\code{layout} is \code{"bin"} or \code{"hex"}, as the other layout methods fully determine both \emph{x} and \emph{y} positions.}
\item{\code{side}: Which side to place the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).}
\item{\code{scale}: What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space.}
\item{\code{justification}: Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to 0.5.}
\item{\code{datatype}: When using composite geoms directly without a \code{stat} (e.g. \code{\link[=geom_slabinterval]{geom_slabinterval()}}), \code{datatype} is used to
indicate which part of the geom a row in the data targets: rows with \code{datatype = "slab"} target the
slab portion of the geometry and rows with \code{datatype = "interval"} target the interval portion of
the geometry. This is set automatically when using ggdist \code{stat}s.}
}

\strong{Interval-specific aesthetics}

\itemize{
\item{\code{xmin}: Left end of the interval sub-geometry (if \code{orientation = "horizontal"}).}
\item{\code{xmax}: Right end of the interval sub-geometry (if \code{orientation = "horizontal"}).}
\item{\code{ymin}: Lower end of the interval sub-geometry (if \code{orientation = "vertical"}).}
\item{\code{ymax}: Upper end of the interval sub-geometry (if \code{orientation = "vertical"}).}
}

\strong{Point-specific aesthetics}

\itemize{
\item{\code{shape}: Shape type used to draw the \strong{point} sub-geometry.}
}

\strong{Color aesthetics}

\itemize{
\item{\code{colour}: (or \code{color}) The color of the \strong{interval} and \strong{point} sub-geometries.
Use the \code{slab_color}, \code{interval_color}, or \code{point_color} aesthetics (below) to
set sub-geometry colors separately.}
\item{\code{fill}: The fill color of the \strong{slab} and \strong{point} sub-geometries. Use the \code{slab_fill}
or \code{point_fill} aesthetics (below) to set sub-geometry colors separately.}
\item{\code{alpha}: The opacity of the \strong{slab}, \strong{interval}, and \strong{point} sub-geometries. Use the \code{slab_alpha},
\code{interval_alpha}, or \code{point_alpha} aesthetics (below) to set sub-geometry colors separately.}
\item{\code{colour_ramp}: (or \code{color_ramp}) A secondary scale that modifies the \code{color}
scale to "ramp" to another color. See \code{\link[=scale_colour_ramp]{scale_colour_ramp()}} for examples.}
\item{\code{fill_ramp}: A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{\link[=scale_fill_ramp]{scale_fill_ramp()}} for examples.}
}

\strong{Line aesthetics}

\itemize{
\item{\code{linewidth}: Width of the line used to draw the \strong{interval} (except with \code{\link[=geom_slab]{geom_slab()}}: then
it is the width of the \strong{slab}). With composite geometries including an interval and slab,
use \code{slab_linewidth} to set the line width of the \strong{slab} (see below). For \strong{interval}, raw
\code{linewidth} values are transformed according to the \code{interval_size_domain} and \code{interval_size_range}
parameters of the \code{geom} (see above).}
\item{\code{size}: Determines the size of the \strong{point}. If \code{linewidth} is not provided, \code{size} will
also determines the width of the line used to draw the \strong{interval} (this allows line width and
point size to be modified together by setting only \code{size} and not \code{linewidth}). Raw
\code{size} values are transformed according to the \code{interval_size_domain}, \code{interval_size_range},
and \code{fatten_point} parameters of the \code{geom} (see above). Use the \code{point_size} aesthetic
(below) to set sub-geometry size directly without applying the effects of
\code{interval_size_domain}, \code{interval_size_range}, and \code{fatten_point}.}
\item{\code{stroke}: Width of the outline around the \strong{point} sub-geometry.}
\item{\code{linetype}: Type of line (e.g., \code{"solid"}, \code{"dashed"}, etc) used to draw the \strong{interval}
and the outline of the \strong{slab} (if it is visible). Use the \code{slab_linetype} or
\code{interval_linetype} aesthetics (below) to set sub-geometry line types separately.}
}

\strong{Slab-specific color/line override aesthetics}

\itemize{
\item{\code{slab_fill}: Override for \code{fill}: the fill color of the slab.}
\item{\code{slab_colour}: (or \code{slab_color}) Override for \code{colour}/\code{color}: the outline color of the slab.}
\item{\code{slab_alpha}: Override for \code{alpha}: the opacity of the slab.}
\item{\code{slab_linewidth}: Override for \code{linwidth}: the width of the outline of the slab.}
\item{\code{slab_linetype}: Override for \code{linetype}: the line type of the outline of the slab.}
\item{\code{slab_shape}: Override for \code{shape}: the shape of the dots used to draw the dotplot slab.}
}

\strong{Interval-specific color/line override aesthetics}

\itemize{
\item{\code{interval_colour}: (or \code{interval_color}) Override for \code{colour}/\code{color}: the color of the interval.}
\item{\code{interval_alpha}: Override for \code{alpha}: the opacity of the interval.}
\item{\code{interval_linetype}: Override for \code{linetype}: the line type of the interval.}
}

\strong{Point-specific color/line override aesthetics}

\itemize{
\item{\code{point_fill}: Override for \code{fill}: the fill color of the point.}
\item{\code{point_colour}: (or \code{point_color}) Override for \code{colour}/\code{color}: the outline color of the point.}
\item{\code{point_alpha}: Override for \code{alpha}: the opacity of the point.}
\item{\code{point_size}: Override for \code{size}: the size of the point.}
}

\strong{Deprecated aesthetics}

\itemize{
\item{\code{slab_size}: Use \code{slab_linewidth}.}
\item{\code{interval_size}: Use \code{interval_linewidth}.}
}

\strong{Other aesthetics} (these work as in standard \code{geom}s)

\itemize{
\item{\code{width}}
\item{\code{height}}
\item{\code{group}}
}

See examples of some of these aesthetics in action in \code{vignette("dotsinterval")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the
\link[ggdist]{scales} documentation. Learn more about basic ggplot aesthetics in
\code{vignette("ggplot2-specs")}.
}

\examples{

library(dplyr)
library(ggplot2)

data(RankCorr_u_tau, package = "ggdist")

# orientation is detected automatically based on
# which axis is discrete

RankCorr_u_tau \%>\%
  ggplot(aes(x = u_tau)) +
  geom_dots()

RankCorr_u_tau \%>\%
  ggplot(aes(y = u_tau)) +
  geom_dots()

# stat_dots can summarize quantiles, creating quantile dotplots

RankCorr_u_tau \%>\%
  ggplot(aes(x = u_tau, y = factor(i))) +
  stat_dots(quantiles = 100)

# color and fill aesthetics can be mapped within the geom
# dotsinterval adds an interval

RankCorr_u_tau \%>\%
  ggplot(aes(x = u_tau, y = factor(i), fill = after_stat(x > 6))) +
  stat_dotsinterval(quantiles = 100)

}
\references{
Kay, M., Kola, T., Hullman, J. R., & Munson, S. A. (2016). When (ish) is My Bus? User-centered Visualizations
of Uncertainty in Everyday, Mobile Predictive Systems. \emph{Conference on Human Factors
in Computing Systems - CHI '16}, 5092--5103. \doi{10.1145/2858036.2858558}.

Fernandes, M., Walls, L., Munson, S., Hullman, J., & Kay, M. (2018). Uncertainty Displays Using Quantile Dotplots
or CDFs Improve Transit Decision-Making. \emph{Conference on Human Factors in Computing Systems - CHI '18}.
\doi{10.1145/3173574.3173718}.
}
\seealso{
See the \code{\link[=stat_slabinterval]{stat_slabinterval()}} family for other
stats built on top of \code{\link[=geom_slabinterval]{geom_slabinterval()}}.
See \code{vignette("dotsinterval")} for a variety of examples of use.

Other dotsinterval geoms: 
\code{\link{geom_dots}()},
\code{\link{geom_swarm}()},
\code{\link{geom_weave}()}
}
\author{
Matthew Kay
}
\concept{dotsinterval geoms}
