% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_slabinterval.R
\name{geom_slabinterval}
\alias{geom_slabinterval}
\alias{geom_slab}
\title{Slab + point + interval meta-geom}
\usage{
geom_slabinterval(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  side = c("topright", "top", "right", "bottomleft", "bottom", "left", "topleft",
    "bottomright", "both"),
  scale = 0.9,
  orientation = NA,
  justification = NULL,
  normalize = c("all", "panels", "xy", "groups", "none"),
  interval_size_domain = c(1, 6),
  interval_size_range = c(0.6, 1.4),
  fatten_point = 1.8,
  show_slab = TRUE,
  show_point = TRUE,
  show_interval = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_slab(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}.}

\item{side}{Which side to draw the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).}

\item{scale}{What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space.}

\item{orientation}{Whether this geom is drawn horizontally (\code{"horizontal"}) or
vertically (\code{"vertical"}). The default, \code{NA}, automatically detects the orientation based on how the
aesthetics are assigned, and should generally do an okay job at this. When horizontal (resp. vertical),
the geom uses the \code{y} (resp. \code{x}) aesthetic to identify different groups, then for each group uses
the \code{x} (resp. \code{y}) aesthetic and the \code{thickness} aesthetic to draw a function as an slab, and draws
points and intervals horizontally (resp. vertically) using the \code{xmin}, \code{x}, and \code{xmax} (resp.
\code{ymin}, \code{y}, and \code{ymax}) aesthetics. For compatibility with the base
ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias for \code{"vertical"} and \code{"y"} as an alias for
\code{"horizontal"} (tidybayes had an \code{orientation} parameter before ggplot did, and I think the tidybayes naming
scheme is more intuitive: \code{"x"} and \code{"y"} are not orientations and their mapping to orientations is, in my
opinion, backwards; but the base ggplot naming scheme is allowed for compatibility).}

\item{justification}{Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to
\code{0.5}.}

\item{normalize}{How to normalize heights of functions input to the \code{thickness} aesthetic. If \code{"all"}
(the default), normalize so that the maximum height across all data is \code{1}; if \code{"panels"}, normalize within
panels so that the maximum height in each panel is \code{1}; if \code{"xy"}, normalize within
the x/y axis opposite the \code{orientation} of this geom so that the maximum height at each value of the
opposite axis is \code{1}; if \code{"groups"}, normalize within values of the opposite axis and within
groups so that the maximum height in each group is \code{1}; if \code{"none"}, values are taken as is with no
normalization (this should probably only be used with functions whose values are in [0,1], such as CDFs).}

\item{interval_size_domain}{The minimum and maximum of the values of the size aesthetic that will be translated into actual
sizes for intervals drawn according to \code{interval_size_range} (see the documentation for that argument.)}

\item{interval_size_range}{(Deprecated). This geom scales the raw size aesthetic values when drawing interval and point sizes, as
they tend to be too thick when using the default settings of \code{\link[=scale_size_continuous]{scale_size_continuous()}}, which give sizes
with a range of \code{c(1, 6)}. The \code{interval_size_domain} value indicates the input domain of raw size values
(typically this should be equal to the value of the \code{range} argument of the \code{\link[=scale_size_continuous]{scale_size_continuous()}}
function), and \code{interval_size_range} indicates the desired output range of the size values (the min and max of
the actual sizes used to draw intervals). Most of the time it is not recommended to change the value of this argument,
as it may result in strange scaling of legends; this argument is a holdover from earlier versions
that did not have size aesthetics targeting the point and interval separately. If you want to adjust the
size of the interval or points separately, you can instead use the \code{interval_size} or \code{point_size}
aesthetics; see \link{scales}.}

\item{fatten_point}{A multiplicative factor used to adjust the size of the point relative to the size of the
thickest interval line. If you wish to specify point sizes directly, you can also use the \code{point_size}
aesthetic and \code{\link[=scale_point_size_continuous]{scale_point_size_continuous()}} or \code{\link[=scale_point_size_discrete]{scale_point_size_discrete()}}; sizes
specified with that aesthetic will not be adjusted using \code{fatten_point}.}

\item{show_slab}{Should the slab portion of the geom be drawn? Default \code{TRUE}.}

\item{show_point}{Should the point portion of the geom be drawn? Default \code{TRUE}.}

\item{show_interval}{Should the interval portion of the geom be drawn? Default \code{TRUE}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Geom} representing a slab or combined slab+interval geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
This meta-geom supports drawing combinations of functions (as slabs, aka ridge plots or joy plots), points, and
intervals. It acts as a meta-geom for many other tidybayes geoms that are wrappers around this geom, including
eye plots, half-eye plots, CCDF barplots, and point+multiple interval plots, and supports both horizontal and
vertical orientations, dodging (via the \code{position} argument), and relative justification of slabs with their
corresponding intervals.
}
\details{
\code{geom_slabinterval} is a flexible meta-geom that you can use directly or through a variety of "shortcut"
geoms that represent useful combinations of the various parameters of this geom. In many cases you will want to
use the shortcut geoms instead as they create more useful mnemonic primitives, such as eye plots,
half-eye plots, point+interval plots, or CCDF barplots.

The \emph{slab} portion of the geom is much like a ridge or "joy" plot: it represents the value of a function
scaled to fit between values on the x or y access (depending on the value of \code{orientation}). Values of
the functions are specified using the \code{thickness} aesthetic and are scaled to fit into \code{scale}
times the distance between points on the relevant axis. E.g., if \code{orientation} is \code{"horizontal"},
\code{scale} is 0.9, and \code{y} is a discrete variable, then the \code{thickness} aesthetic specifies the
value of some function of \code{x} that is drawn for every \code{y} value and scaled to fit into 0.9 times
the distance between points on the y axis.

For the \emph{interval} portion of the geom, \code{x} and \code{y} aesthetics specify the location of the
point and \code{ymin}/\code{ymax} or \code{xmin}/\code{xmax} (depending on the value of \code{orientation}
specifying the endpoints of the interval. A scaling factor for interval line width and point size is applied
through the \code{interval_size_domain}, \code{interval_size_range}, and \code{fatten_point} parameters.
These scaling factors are designed to give multiple uncertainty intervals reasonable
scaling at the default settings for \code{\link[=scale_size_continuous]{scale_size_continuous()}}.

As a combination geom, this geom expects a \code{datatype} aesthetic specifying which part of the geom a given
row in the input data corresponds to: \code{"slab"} or \code{"interval"}. However, specifying this aesthetic
manually is typically only necessary if you use this geom directly; the numerous wrapper geoms will
usually set this aesthetic for you as needed, and their use is recommended unless you have a very custom
use case.

Wrapper geoms and stats include:
\itemize{
\item \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} and associated stats
\item \code{\link[=stat_dist_slabinterval]{stat_dist_slabinterval()}} and associated stats
\item \code{\link[=geom_pointinterval]{geom_pointinterval()}} / \code{\link[=stat_pointinterval]{stat_pointinterval()}}
\item \code{\link[=geom_interval]{geom_interval()}} / \code{\link[=stat_interval]{stat_interval()}}
\item \code{\link[=geom_dots]{geom_dots()}} / \code{\link[=stat_dots]{stat_dots()}}
}

Typically, the \verb{geom_*} versions are meant for use with already-summarized data (such as intervals) and the
\verb{stat_*} versions are summarize the data themselves (usually draws from a distribution) to produce the geom.
}
\section{Aesthetics}{

These geoms support the following aesthetics:
\itemize{
\item \code{x}
\item \code{y}
\item \code{datatype}
\item \code{alpha}
\item \code{colour}
\item \code{colour_ramp}
\item \code{linetype}
\item \code{fill}
\item \code{shape}
\item \code{stroke}
\item \code{point_colour}
\item \code{point_fill}
\item \code{point_alpha}
\item \code{point_size}
\item \code{size}
\item \code{interval_colour}
\item \code{interval_alpha}
\item \code{interval_size}
\item \code{interval_linetype}
\item \code{slab_size}
\item \code{slab_colour}
\item \code{slab_fill}
\item \code{slab_alpha}
\item \code{slab_linetype}
\item \code{fill_ramp}
\item \code{ymin}
\item \code{ymax}
\item \code{xmin}
\item \code{xmax}
\item \code{width}
\item \code{height}
\item \code{thickness}
\item \code{group}
}
See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom aesthetics (like \code{interval_color}) in the \link[ggdist]{scales} documentation.
Learn more about basic ggplot aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{

# geom_slabinterval() is typically not that useful on its own.
# See vignette("slabinterval") for a variety of examples of the use of its
# shortcut geoms and stats, which are more useful than using
# geom_slabinterval() directly.

}
\seealso{
See \code{\link[=geom_lineribbon]{geom_lineribbon()}} for a combination geom designed for fit curves plus probability bands.
See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} and \code{\link[=stat_dist_slabinterval]{stat_dist_slabinterval()}} for families of stats
built on top of this geom for common use cases (like \code{\link[=stat_halfeye]{stat_halfeye()}}).
See \code{vignette("slabinterval")} for a variety of examples of use.
}
\author{
Matthew Kay
}
