% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdiceplot-package.R
\docType{package}
\name{ggdiceplot-package}
\alias{ggdiceplot}
\alias{ggdiceplot-package}
\title{ggdiceplot: Dice Plot Visualization for ggplot2}
\description{
The \strong{ggdiceplot} package provides extensions for \code{ggplot2} that allow
visualizing data using dice-based dot patterns. The main feature is
\code{geom_dice()}, which displays categorical variables using traditional dice
face layouts (1 to 6 dots). This is especially helpful for multidimensional
categorical data visualization.
}
\section{Main Functions}{

\itemize{
\item \code{\link{geom_dice}} — Display dice representations for data points
\item \code{\link{create_dice_positions}} — Generate dice dot patterns for integers 1–6
\item \code{\link{make_offsets}} — Internal function to calculate x/y offsets for dot placement
}
}

\section{Features}{

\itemize{
\item Seamless integration with ggplot2
\item Traditional dice dot layouts
\item Customizable appearance (size, color, transparency)
\item Support for faceting and multiple aesthetics
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/maflot/ggdiceplot}
  \item Report bugs at \url{https://github.com/maflot/ggdiceplot/issues}
}

}
\author{
\strong{Maintainer}: Matthias Flotho \email{matthias.flotho@ccb.uni-saarland.de} (\href{https://orcid.org/0009-0006-4374-0801}{ORCID})

}
\keyword{internal}
