% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbrain_layer.R
\name{ggbrain_layer}
\alias{ggbrain_layer}
\title{R6 class for a single layer of a ggbrain panel}
\value{
a \code{ggbrain_layer} R6 class containing fields related to a visual layer on the \code{ggbrain} plot
}
\description{
R6 class for a single layer of a ggbrain panel

R6 class for a single layer of a ggbrain panel
}
\details{
Note that this class is exported only for power users and rarely needs to be called directly
in typical use of the package. Instead, look at geom_brain() and geom_outline().
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{the name of this layer, used for referencing in layer and panel modifications}

\item{\code{all_na}}{whether all values for this layer are NA in the \code{data} field}

\item{\code{definition}}{a character string specifying the image name or contrast that defines this layer}

\item{\code{source}}{a character string specifying the layer source within a relevant ggbrain_slices object.
This is used to lookup the right layer information when combining slices and layers together
Note that multiple layers can potentially have the same source, which is why a 1:1 mapping to name does not work}

\item{\code{data}}{the data.frame containing relevant data for this layer.}

\item{\code{show_legend}}{a logical indicating whether to show or hide the fill/color scale}

\item{\code{unify_scales}}{a logical indicating whether to unify scale limits and levels when this layer
is added across many panels}

\item{\code{bisided}}{read-only access to whether this layer uses a bisided color scale}

\item{\code{categorical_fill}}{read-only access to whether this layer has a categorical fill scale}

\item{\code{fill_column}}{read-only access to layer fill column}

\item{\code{fill_scale}}{a scale_fill_* object containing the ggplot2 fill scale for this layer}

\item{\code{alpha}}{sets the alpha transparency of this layer.}

\item{\code{blur_edge}}{controls the standard deviation (sigma) of a Gaussian blur applied to the layer at the edge}

\item{\code{trim_threads}}{iteratively trim any pixels that have fewer than this number of neighboring pixels}

\item{\code{fill_holes}}{controls the size of holes to be filled for display (in pixels)}

\item{\code{remove_specks}}{controls the size of specks to be removed (in pixels)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ggbrain_layer-new}{\code{ggbrain_layer$new()}}
\item \href{#method-ggbrain_layer-set_limits}{\code{ggbrain_layer$set_limits()}}
\item \href{#method-ggbrain_layer-set_pos_limits}{\code{ggbrain_layer$set_pos_limits()}}
\item \href{#method-ggbrain_layer-set_neg_limits}{\code{ggbrain_layer$set_neg_limits()}}
\item \href{#method-ggbrain_layer-set_breaks}{\code{ggbrain_layer$set_breaks()}}
\item \href{#method-ggbrain_layer-set_pos_breaks}{\code{ggbrain_layer$set_pos_breaks()}}
\item \href{#method-ggbrain_layer-set_neg_breaks}{\code{ggbrain_layer$set_neg_breaks()}}
\item \href{#method-ggbrain_layer-plot}{\code{ggbrain_layer$plot()}}
\item \href{#method-ggbrain_layer-add_to_gg}{\code{ggbrain_layer$add_to_gg()}}
\item \href{#method-ggbrain_layer-get_data}{\code{ggbrain_layer$get_data()}}
\item \href{#method-ggbrain_layer-is_empty}{\code{ggbrain_layer$is_empty()}}
\item \href{#method-ggbrain_layer-clone}{\code{ggbrain_layer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-new"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-new}{}}}
\subsection{Method \code{new()}}{
create a new ggbrain_layer object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$new(
  name = NULL,
  definition = NULL,
  limits = NULL,
  breaks = integer_breaks(),
  show_legend = TRUE,
  interpolate = NULL,
  unify_scales = TRUE,
  alpha = NULL,
  blur_edge = NULL,
  fill_holes = NULL,
  remove_specks = NULL,
  trim_threads = NULL,
  data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the name of this layer, used for referencing in layer and panel modifications}

\item{\code{definition}}{an optional character string defining the image or contrast that should be used
to lookup data from a ggbrain_slices object. This is mostly used internally by the ggbrain + syntax
to allow layers to be defined without data in advance of the plot.}

\item{\code{limits}}{if provided, sets the upper and lower bounds on the scale}

\item{\code{breaks}}{if provided, a function to draw the breaks on the color scale}

\item{\code{show_legend}}{if TRUE, show the scale on the plot legend}

\item{\code{interpolate}}{passes to geom_raster and controls whether the fill is interpolated over continuous space}

\item{\code{unify_scales}}{if TRUE, when this layer is reused across panels, unify the scales to match}

\item{\code{alpha}}{fixed alpha transparency of this layer (use \code{mapping} for alpha mapping`)}

\item{\code{blur_edge}}{the standard deviation (sigma) of a Gaussian kernel applied to the edge of this layer to
smooth it. This makes the layer less jagged in appearance and is akin to antialiasing.}

\item{\code{fill_holes}}{the size of holes (in pixels) inside clusters to be filled by nearest neighbor imputation prior to display}

\item{\code{remove_specks}}{the size of specks (in pixels) to be removed from each slice prior to display}

\item{\code{trim_threads}}{the minimum number of neighboring pixels (including diagonals) that must be present to keep a pixel}

\item{\code{data}}{the data.frame containing image data for this layer. Must contain "dim1", "dim2",
and "value" as columns}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-set_limits"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-set_limits}{}}}
\subsection{Method \code{set_limits()}}{
set the limits for this layer's scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$set_limits(limits)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limits}}{a 2-element numeric vector setting the lower and upper limits on the layer's scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-set_pos_limits"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-set_pos_limits}{}}}
\subsection{Method \code{set_pos_limits()}}{
set the limits for this layer's positive scale (only relevant to bisided)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$set_pos_limits(limits)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limits}}{a 2-element numeric vector setting the lower and upper limits on the layer's positive scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-set_neg_limits"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-set_neg_limits}{}}}
\subsection{Method \code{set_neg_limits()}}{
set the limits for this layer's positive scale (only relevant to bisided)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$set_neg_limits(limits)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limits}}{a 2-element numeric vector setting the lower and upper limits on the layer's positive scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-set_breaks"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-set_breaks}{}}}
\subsection{Method \code{set_breaks()}}{
set the breaks element of this layer's scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$set_breaks(breaks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{breaks}}{a function used to label the breaks}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-set_pos_breaks"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-set_pos_breaks}{}}}
\subsection{Method \code{set_pos_breaks()}}{
set the breaks element of this layer's positive scale (only relevant to bisided)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$set_pos_breaks(breaks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{breaks}}{a function used to label the positive breaks}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-set_neg_breaks"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-set_neg_breaks}{}}}
\subsection{Method \code{set_neg_breaks()}}{
set the breaks element of this layer's negative scale (only relevant to bisided)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$set_neg_breaks(breaks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{breaks}}{a function used to label the negative breaks}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-plot}{}}}
\subsection{Method \code{plot()}}{
plot this layer alone (mostly for debugging)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-add_to_gg"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-add_to_gg}{}}}
\subsection{Method \code{add_to_gg()}}{
method to add this layer to an existing ggplot object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$add_to_gg(base_gg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_gg}}{the ggplot object to which we add the layer}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-get_data}{}}}
\subsection{Method \code{get_data()}}{
return the data.frame associated with this layer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$get_data(add_layer_name = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{add_layer_name}}{if TRUE, adds a \code{layer_name} column to the data.frame for record-keeping.
Default: FALSE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
returns TRUE if all values are NA or if the data has 0 rows
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$is_empty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
