% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_tooltip_text.R
\name{add_tooltip_text}
\alias{add_tooltip_text}
\title{Add a tooltip text column of united variable names and values.}
\usage{
add_tooltip_text(data, ..., titles = NULL)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{...}{Arguments passed to select (i.e unquoted variables, tidyselect helpers etc). If no arguments provided, uses all columns.}

\item{titles}{A function to format the variable names, including in rlang lambda format.}
}
\value{
A data frame or tibble with a column of text
}
\description{
Add a tooltip text column of united variable names and values.
}
\examples{
iris \%>\%
  add_tooltip_text() \%>\%
  head(1)

 iris \%>\%
  add_tooltip_text(Species, tidyselect::contains("Sepal")) \%>\%
  head(1)

  library(snakecase)

 iris \%>\%
  add_tooltip_text(titles = ~ to_sentence_case(.x)) \%>\%
  head(1)

 iris \%>\%
   add_tooltip_text() \%>\%
   gg_point(x = Sepal.Width,
            y = Sepal.Length,
            col = Species,
            text = text,
            theme = gg_theme("helvetica", grid_v = TRUE, grid_h = TRUE)) \%>\%
    plotly::ggplotly(tooltip = "text")
}
