% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.R
\name{mark_draw}
\alias{mark_draw}
\title{Define the links to connect the marked observations}
\usage{
mark_draw(.draw, ...)
}
\arguments{
\item{.draw}{A function used to draw the links. The function must return a
\code{\link[grid:grid.grob]{grob()}} object. If the function does not return a valid
\code{grob}, nothing will be drawn. The input data for the function must contain
two arguments: a data frame for the panel side coordinates and a data frame
for the marked observation coordinates.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> A list of formulas, where each side
of the formula should be an \code{integer} or \code{character} index of the original
data, or a \code{range_link()} object defining the linked observations. Use
\code{NULL} to indicate no link on that side. You can also combine these by
wrapping them into a single \code{list()}. If only the left-hand side of the
formula exists, you can input it directly. For integer indices, wrap them
with \code{\link[=I]{I()}} to use the ordering from the layout. You can also use
\code{\link[ggplot2:waiver]{waiver()}} to inherit values from the other group.}
}
\description{
This function allows users to define links between marked observations and
plot panel (e.g., for creating visual connections for related data), which
could help explain the observations.
}
\seealso{
\itemize{
\item \code{\link[=mark_line]{mark_line()}}
\item \code{\link[=mark_tetragon]{mark_tetragon()}}
\item \code{\link[=mark_triangle]{mark_triangle()}}
\item \code{\link[=.mark_draw]{.mark_draw()}}
}
}
