% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-quad-.R
\name{quad_free}
\alias{quad_free}
\alias{ggside}
\alias{quad_alignh}
\alias{quad_alignv}
\alias{quad_alignb}
\title{Arrange Plots in the Quad-Side of a main plot}
\usage{
quad_free(
  data = NULL,
  mapping = aes(),
  ...,
  theme = NULL,
  active = NULL,
  width = NA,
  height = NA
)

quad_alignh(
  data = NULL,
  mapping = aes(),
  ...,
  theme = NULL,
  active = NULL,
  width = NA,
  height = NA
)

quad_alignv(
  data = NULL,
  mapping = aes(),
  ...,
  theme = NULL,
  active = NULL,
  width = NA,
  height = NA
)

quad_alignb(
  data = NULL,
  mapping = aes(),
  ...,
  theme = NULL,
  active = NULL,
  width = NA,
  height = NA
)
}
\arguments{
\item{data}{Default dataset to use for the layout. If not specified, it must be supplied in each plot added to the layout. By default, it will try to inherit from parent layout.
\itemize{
\item For \code{quad_free}/\code{ggside}, the function uses \code{\link[=fortify_data_frame]{fortify_data_frame()}} to
convert the data into a data frame.
\item For all other functions, it employs \code{\link[=fortify_matrix]{fortify_matrix()}} to convert
the data into a matrix.
}}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{Additional arguments passed to \code{\link[=fortify_matrix]{fortify_matrix()}} or
\code{\link[=fortify_data_frame]{fortify_data_frame()}}.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} used to render the \code{guides},
\code{title}, \code{subtitle}, \code{caption}, \code{margins}, \code{patch.title}, \code{panel.border}, and
\code{background}. If \code{NULL} (default), will inherit from the parent \code{layout}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}

\item{width, height}{The relative width/height of the main plot, can be a
\code{\link[grid:unit]{unit}} object.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

These functions arrange plots around a main plot, allowing for flexible
alignment of observations in different directions. \code{ggside} is an alias for
\code{quad_free}.

\itemize{
\item \code{quad_free}/\code{ggside}: Never align observations.
\item \code{quad_alignh}: Align observations in the horizontal direction.
\item \code{quad_alignv}: Align observations in the vertical direction.
\item \code{quad_alignb}: Align observations in both horizontal and vertical
directions.
}
}
\section{ggplot2 specification}{

For \code{quad_alignb}, \code{quad_alignh}, and \code{quad_alignv}, the data input will be
converted into the long formated data frame when drawing. The data in the
underlying \code{ggplot} object contains following columns:
\itemize{
\item \code{.xpanel} and \code{.ypanel}: the column and row panel
\item \code{.x} and \code{.y}: the \code{x} and \code{y} coordinates
\item \code{.row_names} and \code{.column_names}: A factor of the row and column names of
the original matrix (only applicable when names exist).
\item \code{.row_index} and \code{.column_index}: the row and column index of the original
matrix.
\item \code{value}: the actual matrix value.
}
}

