% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-inset.R
\name{patch.trellis}
\alias{patch.trellis}
\title{Convert Object into a Grob}
\usage{
\method{patch}{trellis}(x, ..., device = NULL)
}
\arguments{
\item{x}{An object to be converted into a \code{\link[grid:grid.grob]{grob}}.}

\item{...}{
  Arguments passed on to \code{\link[grid:grid.grab]{grid::grid.grabExpr}}
  \describe{
    \item{\code{warn}}{ An integer specifying the amount of warnings
    to emit.  0 means no warnings, 1 means warn when it is
    certain that the grab will not faithfully represent the
    original scene. 2 means warn if there's any possibility
    that the grab will not faithfully represent the
    original scene.
  }
    \item{\code{wrap}}{ A logical indicating how the output should
    be captured. If \code{TRUE}, each non-grob element on the
    display list is captured by wrapping it in a grob.
  }
    \item{\code{wrap.grobs}}{ A logical indicating whether, if we are wrapping
    elements (\code{wrap=TRUE}), we should wrap grobs (or just
    wrap viewports).
  }
    \item{\code{width,height}}{ Size of the device used for temporary
    rendering. }
  }}

\item{device}{ A function that opens a graphics device for temporary
    rendering. By default this is an off-screen, in-memory device
    based on the \code{pdf} device, but this default device may not be
    satisfactory when using custom fonts.
  }
}
\value{
A \code{\link[grid:grid.grob]{grob}} object.
}
\description{
The \code{patch()} function is used by \code{\link[=ggwrap]{ggwrap()}} and \code{\link[=inset]{inset()}} to convert
objects into a \code{\link[grid:grid.grob]{grob}}.
}
\seealso{
\code{\link[lattice:trellis.object]{trellis}}

Other patch methods: 
\code{\link{patch.Heatmap}()},
\code{\link{patch.alignpatches}()},
\code{\link{patch.formula}()},
\code{\link{patch.ggplot}()},
\code{\link{patch.grob}()},
\code{\link{patch.patch}()},
\code{\link{patch.patch_ggplot}()},
\code{\link{patch.patchwork}()},
\code{\link{patch.pheatmap}()},
\code{\link{patch.recordedplot}()}
}
\concept{patch methods}
