## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ggalign)

## ----setup_data---------------------------------------------------------------
set.seed(123)
small_mat <- matrix(rnorm(81), nrow = 9)
rownames(small_mat) <- paste0("row", seq_len(nrow(small_mat)))
colnames(small_mat) <- paste0("column", seq_len(ncol(small_mat)))

## -----------------------------------------------------------------------------
ggheatmap(small_mat) + scale_fill_viridis_c()

## -----------------------------------------------------------------------------
ggheatmap(small_mat) +
    scale_fill_viridis_c() +
    hmanno("t") +
    align_dendro(aes(color = branch), k = 3) +
    geom_point(aes(color = branch, y = y)) +
    scale_color_brewer(palette = "Dark2")

## -----------------------------------------------------------------------------
ggheatmap(small_mat) +
    scale_fill_viridis_c() +
    hmanno("t") +
    align_kmeans(3L)

## -----------------------------------------------------------------------------
ggheatmap(small_mat) +
    scale_fill_viridis_c() +
    hmanno("t") +
    align_group(sample(letters[1:4], ncol(small_mat), replace = TRUE))

## -----------------------------------------------------------------------------
ggheatmap(small_mat) +
    scale_fill_viridis_c() +
    hmanno("l") +
    align_order(rowMeans)

## ----eval=rlang::is_installed("seriation")------------------------------------
ggheatmap(small_mat) +
    scale_fill_viridis_c() +
    hmanno("l") +
    align_reorder(seriation::seriate)

## -----------------------------------------------------------------------------
ggheatmap(small_mat) +
    scale_fill_viridis_c() +
    hmanno("t") +
    align_dendro(aes(color = branch), k = 3) +
    geom_point(aes(color = branch, y = y)) +
    scale_color_brewer(palette = "Dark2") +
    ggalign(aes(y = value)) +
    geom_boxplot(aes(factor(.x), fill = .panel)) +
    scale_fill_brewer(palette = "Dark2")

## ----fig.dim = c(10, 8)-------------------------------------------------------
ggheatmap(small_mat) +
    scale_fill_viridis_c() +
    hmanno("t", size = 0.5) +
    align_dendro(aes(color = branch), k = 3L) +
    ggalign(aes(y = value), data = rowSums) +
    geom_bar(stat = "identity", aes(fill = factor(.panel))) +
    scale_fill_brewer(name = NULL, palette = "Dark2") +
    hmanno("l", size = 0.5) +
    align_dendro(aes(color = branch), size = 0.5, k = 4L) +
    ggalign(aes(x = value), data = rowSums) +
    geom_bar(
        aes(y = .y, fill = factor(.y)),
        stat = "identity",
        orientation = "y"
    ) +
    scale_fill_brewer(name = NULL, palette = "Paired", guide = "none")

## -----------------------------------------------------------------------------
(ggstack(small_mat) +
    ggheatmap() +
    ggheatmap() &
    scale_fill_viridis_c() &
    theme(axis.text.x = element_text(angle = -60, hjust = 0))) +
    stack_active() +
    align_dendro(aes(color = branch), k = 4L, size = 0.2) +
    scale_color_brewer(palette = "Dark2")

## ----fig.height = 6-----------------------------------------------------------
ggstack(small_mat, "v") +
    align_dendro(aes(color = branch),
        k = 4L, size = 0.2,
        theme = theme(axis.text.x = element_blank())
    ) +
    scale_color_brewer(palette = "Dark2") +
    ggheatmap() +
    ggheatmap() &
    scale_fill_viridis_c() &
    theme(axis.text.x = element_text(angle = -60, hjust = 0))

## -----------------------------------------------------------------------------
sessionInfo()

